/*
 * Decompiled with CFR 0.152.
 */
import cmd.BaseOperateCommand;
import cmd.CommandUtil;
import datasource.DataSourceConfig;
import java.sql.SQLException;
import org.apache.commons.cli.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchToolLauncher {
    private static final Logger logger = LoggerFactory.getLogger(BatchTool.class);
    private static final BatchTool BATCH_TOOL_INSTANCE = BatchTool.getInstance();

    public static void main(String[] args) {
        if (args.length == 0) {
            CommandUtil.printHelp();
            return;
        }
        CommandLine commandLine = CommandUtil.parseStartUpCommand(args);
        if (commandLine == null || CommandUtil.doHelpCmd(commandLine)) {
            return;
        }
        try {
            BatchToolLauncher.handleCmd(commandLine);
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            System.exit(1);
        }
    }

    private static void handleCmd(CommandLine commandLine) throws SQLException {
        DataSourceConfig dataSourceConfig;
        try {
            dataSourceConfig = CommandUtil.getDataSourceConfigFromCmd(commandLine);
            BATCH_TOOL_INSTANCE.initDatasource(dataSourceConfig);
        }
        catch (SQLException e) {
            logger.error("Connect to database failed");
            throw e;
        }
        BaseOperateCommand command = CommandUtil.getOperateCommandFromCmd(commandLine);
        BATCH_TOOL_INSTANCE.doBatchOp(command, dataSourceConfig);
    }
}

