/*
 * Decompiled with CFR 0.152.
 */
package cmd;

import cmd.BaseOperateCommand;
import cmd.CommandType;
import cmd.DeleteCommand;
import cmd.ExportCommand;
import cmd.ImportCommand;
import cmd.UpdateCommand;
import com.google.common.collect.Lists;
import datasource.DataSourceConfig;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import model.ConsumerExecutionContext;
import model.ProducerExecutionContext;
import model.config.BenchmarkMode;
import model.config.CompressMode;
import model.config.ConfigConstant;
import model.config.DdlMode;
import model.config.EncryptionConfig;
import model.config.ExportConfig;
import model.config.FileFormat;
import model.config.FileLineRecord;
import model.config.GlobalVar;
import model.config.QuoteEncloseMode;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.FileUtil;
import util.Version;

public class CommandUtil {
    private static final Logger logger = LoggerFactory.getLogger(CommandUtil.class);
    private static final HelpFormatter formatter = new HelpFormatter();
    private static final Options options = new Options();

    public static CommandLine parseStartUpCommand(String[] args) {
        DefaultParser parser = new DefaultParser();
        CommandLine result = null;
        try {
            result = parser.parse(options, args);
        }
        catch (ParseException e) {
            logger.error(e.getMessage());
            CommandUtil.printHelp();
        }
        return result;
    }

    private static void validateDataSourceArgs(CommandLine result) {
        CommandUtil.requireArg(result, "h");
        CommandUtil.requireArg(result, "u");
        CommandUtil.requireArg(result, "p");
        CommandUtil.requireArg(result, "D");
    }

    public static DataSourceConfig getDataSourceConfigFromCmd(CommandLine result) {
        CommandUtil.validateDataSourceArgs(result);
        DataSourceConfig.DataSourceConfigBuilder configBuilder = new DataSourceConfig.DataSourceConfigBuilder();
        configBuilder.host(result.getOptionValue("h")).dbName(result.getOptionValue("D")).username(result.getOptionValue("u")).password(result.getOptionValue("p")).maxConnNumber(CommandUtil.getMaxConnNum(result)).minConnNumber(CommandUtil.getMinConnNum(result)).maxWait(CommandUtil.getMaxWait(result)).connParam(CommandUtil.getConnParam(result)).initSqls(CommandUtil.getInitSqls(result));
        if (result.hasOption("lb")) {
            configBuilder.loadBalanceEnabled(true);
        } else {
            configBuilder.port(result.getOptionValue("P")).loadBalanceEnabled(false);
        }
        return configBuilder.build();
    }

    private static int getMaxWait(CommandLine result) {
        if (result.hasOption("maxWait")) {
            return Integer.parseInt(result.getOptionValue("maxWait"));
        }
        return 5000;
    }

    private static int getMaxConnNum(CommandLine result) {
        if (result.hasOption("maxConn")) {
            return Integer.parseInt(result.getOptionValue("maxConn"));
        }
        return 1024;
    }

    private static int getMinConnNum(CommandLine result) {
        if (result.hasOption("minConn")) {
            return Integer.parseInt(result.getOptionValue("minConn"));
        }
        return 32;
    }

    private static String getConnParam(CommandLine result) {
        if (result.hasOption("param")) {
            return result.getOptionValue("param");
        }
        return null;
    }

    private static String getInitSqls(CommandLine result) {
        if (result.hasOption("initSqls")) {
            return result.getOptionValue("initSqls");
        }
        return null;
    }

    public static BaseOperateCommand getOperateCommandFromCmd(CommandLine result) {
        CommandUtil.validateOperateArgs(result);
        BaseOperateCommand command = CommandUtil.initCommand(result);
        CommandUtil.afterInitCommand(command, result);
        return command;
    }

    private static void validateOperateArgs(CommandLine result) {
        CommandUtil.requireArg(result, "o");
        CommandUtil.requireArg(result, "s");
        CommandUtil.requireArg(result, "D");
    }

    private static BaseOperateCommand initCommand(CommandLine result) {
        String commandTypeStr = result.getOptionValue("o");
        CommandType commandType = CommandUtil.lookup(commandTypeStr);
        BaseOperateCommand command = null;
        switch (commandType) {
            case EXPORT: {
                command = CommandUtil.parseExportCommand(result);
                break;
            }
            case IMPORT: {
                command = CommandUtil.parseImportCommand(result);
                break;
            }
            case UPDATE: {
                command = CommandUtil.parseUpdateCommand(result);
                break;
            }
            case DELETE: {
                command = CommandUtil.parseDeleteCommand(result);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported command: " + commandTypeStr);
            }
        }
        command.setTableNames(CommandUtil.getTableNames(result));
        command.setColumnNames(CommandUtil.getColumnNames(result));
        return command;
    }

    private static void afterInitCommand(BaseOperateCommand command, CommandLine result) {
        if (result.hasOption("sharding")) {
            boolean shardingEnabled = CommandUtil.parseFlag(result.getOptionValue("sharding"));
            command.setShardingEnabled(shardingEnabled);
        }
    }

    private static List<String> getTableNames(CommandLine result) {
        if (!result.hasOption("t")) {
            return null;
        }
        String tableNameStr = result.getOptionValue("t");
        return Lists.newArrayList(StringUtils.split(tableNameStr, ";"));
    }

    private static List<String> getColumnNames(CommandLine result) {
        if (!result.hasOption("col")) {
            return null;
        }
        String columnNameStr = result.getOptionValue("col");
        return Lists.newArrayList(StringUtils.split(columnNameStr, ";"));
    }

    private static BaseOperateCommand parseImportCommand(CommandLine result) {
        CommandUtil.requireOnlyOneArg(result, "f", "dir", "benchmark");
        ProducerExecutionContext producerExecutionContext = new ProducerExecutionContext();
        ConsumerExecutionContext consumerExecutionContext = new ConsumerExecutionContext();
        CommandUtil.configureCommonContext(result, producerExecutionContext, consumerExecutionContext);
        return new ImportCommand(CommandUtil.getDbName(result), producerExecutionContext, consumerExecutionContext);
    }

    private static BaseOperateCommand parseDeleteCommand(CommandLine result) {
        CommandUtil.requireOnlyOneArg(result, "f", "dir");
        ProducerExecutionContext producerExecutionContext = new ProducerExecutionContext();
        ConsumerExecutionContext consumerExecutionContext = new ConsumerExecutionContext();
        CommandUtil.configureCommonContext(result, producerExecutionContext, consumerExecutionContext);
        consumerExecutionContext.setWhereCondition(CommandUtil.getWhereCondition(result));
        return new DeleteCommand(CommandUtil.getDbName(result), producerExecutionContext, consumerExecutionContext);
    }

    private static BaseOperateCommand parseUpdateCommand(CommandLine result) {
        CommandUtil.requireOnlyOneArg(result, "f", "dir");
        ProducerExecutionContext producerExecutionContext = new ProducerExecutionContext();
        ConsumerExecutionContext consumerExecutionContext = new ConsumerExecutionContext();
        CommandUtil.configureCommonContext(result, producerExecutionContext, consumerExecutionContext);
        consumerExecutionContext.setWhereCondition(CommandUtil.getWhereCondition(result));
        consumerExecutionContext.setFuncSqlForUpdateEnabled(CommandUtil.getFuncEnabled(result));
        return new UpdateCommand(CommandUtil.getDbName(result), producerExecutionContext, consumerExecutionContext);
    }

    private static String getSep(CommandLine result) {
        return result.getOptionValue("s");
    }

    private static Charset getCharset(CommandLine result) {
        if (result.hasOption("cs")) {
            String charset = result.getOptionValue("cs");
            return Charset.forName(charset);
        }
        return ConfigConstant.DEFAULT_CHARSET;
    }

    private static boolean getWithHeader(CommandLine result) {
        return result.hasOption("header");
    }

    private static CompressMode getCompressMode(CommandLine result) {
        if (result.hasOption("comp")) {
            return CompressMode.fromString(result.getOptionValue("comp"));
        }
        return ConfigConstant.DEFAULT_COMPRESS_MODE;
    }

    private static EncryptionConfig getEncryptionConfig(CommandLine result) {
        if (result.hasOption("enc")) {
            String encryptionMode = result.getOptionValue("enc");
            String key = result.getOptionValue("key");
            return EncryptionConfig.parse(encryptionMode, key);
        }
        return ConfigConstant.DEFAULT_ENCRYPTION_CONFIG;
    }

    private static int getReadBlockSizeInMb(CommandLine result) {
        if (result.hasOption("readsize")) {
            return Integer.parseInt(result.getOptionValue("readsize"));
        }
        return 2;
    }

    private static boolean getWithLastSep(CommandLine result) {
        return result.hasOption("lastSep");
    }

    private static FileFormat getFileFormat(CommandLine result) {
        if (result.hasOption("format")) {
            String fileFormat = result.getOptionValue("format");
            return FileFormat.fromString(fileFormat);
        }
        return ConfigConstant.DEFAULT_FILE_FORMAT;
    }

    private static ExportCommand parseExportCommand(CommandLine result) {
        List<String> tableNames = CommandUtil.getTableNames(result);
        ExportConfig exportConfig = new ExportConfig();
        exportConfig.setCharset(CommandUtil.getCharset(result));
        exportConfig.setWithHeader(CommandUtil.getWithHeader(result));
        exportConfig.setSeparator(CommandUtil.getSep(result));
        exportConfig.setWhereCondition(CommandUtil.getWhereCondition(result));
        exportConfig.setDdlMode(CommandUtil.getDdlMode(result));
        exportConfig.setEncryptionConfig(CommandUtil.getEncryptionConfig(result));
        exportConfig.setFileFormat(CommandUtil.getFileFormat(result));
        exportConfig.setCompressMode(CommandUtil.getCompressMode(result));
        exportConfig.setParallelism(CommandUtil.getProducerParallelism(result));
        exportConfig.setQuoteEncloseMode(CommandUtil.getQuoteEncloseMode(result));
        CommandUtil.setFilenamePrefix(result, exportConfig);
        CommandUtil.setFileNum(result, exportConfig);
        CommandUtil.setFileLine(result, exportConfig);
        CommandUtil.setOrderBy(result, exportConfig);
        exportConfig.validate();
        return new ExportCommand(CommandUtil.getDbName(result), tableNames, exportConfig);
    }

    private static void setFilenamePrefix(CommandLine result, ExportConfig exportConfig) {
        if (result.hasOption("pre")) {
            exportConfig.setFilenamePrefix(result.getOptionValue("pre"));
        } else {
            exportConfig.setFilenamePrefix("");
        }
    }

    private static void setOrderBy(CommandLine result, ExportConfig exportConfig) {
        if (result.hasOption("O")) {
            if (!result.hasOption("OC")) {
                throw new IllegalArgumentException("Order column name cannot be empty");
            }
            if (result.hasOption("local")) {
                exportConfig.setLocalMerge(true);
            }
            exportConfig.setAscending(!"desc".equals(result.getOptionValue("O")));
            List<String> columnNameList = Arrays.asList(StringUtils.split(result.getOptionValue("OC"), ";"));
            exportConfig.setOrderByColumnNameList(columnNameList);
            exportConfig.setParallelMerge(CommandUtil.getParaMerge(result));
        }
    }

    private static void setFileLine(CommandLine result, ExportConfig exportConfig) {
        if (result.hasOption("L")) {
            if (exportConfig.getExportWay() != ExportConfig.ExportWay.DEFAULT) {
                throw new IllegalArgumentException("Export way should be unique");
            }
            exportConfig.setExportWay(ExportConfig.ExportWay.MAX_LINE_NUM_IN_SINGLE_FILE);
            exportConfig.setMaxLine(Integer.parseInt(result.getOptionValue("L")));
        }
    }

    private static void setFileNum(CommandLine result, ExportConfig exportConfig) {
        if (result.hasOption("F")) {
            exportConfig.setExportWay(ExportConfig.ExportWay.FIXED_FILE_NUM);
            exportConfig.setFixedFileNum(Integer.parseInt(result.getOptionValue("F")));
            if (exportConfig.getLimitNum() <= 0) {
                throw new IllegalArgumentException("File num should be a positive integer");
            }
        }
    }

    private static boolean getParaMerge(CommandLine result) {
        return result.hasOption("para");
    }

    private static void configureCommonContext(CommandLine result, ProducerExecutionContext producerExecutionContext, ConsumerExecutionContext consumerExecutionContext) {
        CommandUtil.configureGlobalVar(result);
        CommandUtil.configureProducerContext(result, producerExecutionContext);
        CommandUtil.configureConsumerContext(result, consumerExecutionContext);
    }

    private static void configureGlobalVar(CommandLine result) {
        CommandUtil.setBatchSize(result);
        CommandUtil.setRingBufferSize(result);
        CommandUtil.setPerfMode(result);
    }

    private static void configureProducerContext(CommandLine result, ProducerExecutionContext producerExecutionContext) {
        producerExecutionContext.setCharset(CommandUtil.getCharset(result));
        producerExecutionContext.setSeparator(CommandUtil.getSep(result));
        producerExecutionContext.setFileLineRecordList(CommandUtil.getFileRecordList(result));
        producerExecutionContext.setParallelism(CommandUtil.getProducerParallelism(result));
        producerExecutionContext.setReadBlockSizeInMb(CommandUtil.getReadBlockSizeInMb(result));
        producerExecutionContext.setWithHeader(CommandUtil.getWithHeader(result));
        producerExecutionContext.setDdlMode(CommandUtil.getDdlMode(result));
        producerExecutionContext.setCompressMode(CommandUtil.getCompressMode(result));
        producerExecutionContext.setEncryptionConfig(CommandUtil.getEncryptionConfig(result));
        producerExecutionContext.setFileFormat(CommandUtil.getFileFormat(result));
        producerExecutionContext.setMaxErrorCount(CommandUtil.getMaxErrorCount(result));
        producerExecutionContext.setHistoryFileAndParse(CommandUtil.getHistoryFile(result));
        producerExecutionContext.setQuoteEncloseMode(CommandUtil.getQuoteEncloseMode(result));
        producerExecutionContext.setBenchmarkMode(CommandUtil.getBenchmarkMode(result));
        producerExecutionContext.setScale(CommandUtil.getScale(result));
        producerExecutionContext.validate();
    }

    private static void configureConsumerContext(CommandLine result, ConsumerExecutionContext consumerExecutionContext) {
        consumerExecutionContext.setCharset(CommandUtil.getCharset(result));
        consumerExecutionContext.setSeparator(CommandUtil.getSep(result));
        consumerExecutionContext.setInsertIgnoreAndResumeEnabled(CommandUtil.getInsertIgnoreAndResumeEnabled(result));
        consumerExecutionContext.setParallelism(CommandUtil.getConsumerParallelism(result));
        consumerExecutionContext.setForceParallelism(CommandUtil.getForceParallelism(result));
        consumerExecutionContext.setTableNames(CommandUtil.getTableNames(result));
        consumerExecutionContext.setSqlEscapeEnabled(CommandUtil.getSqlEscapeEnabled(result));
        consumerExecutionContext.setReadProcessFileOnly(CommandUtil.getReadAndProcessFileOnly(result));
        consumerExecutionContext.setWhereInEnabled(CommandUtil.getWhereInEnabled(result));
        consumerExecutionContext.setWithLastSep(CommandUtil.getWithLastSep(result));
        consumerExecutionContext.setTpsLimit(CommandUtil.getTpsLimit(result));
        consumerExecutionContext.setUseColumns(CommandUtil.getUseColumns(result));
        consumerExecutionContext.validate();
    }

    private static String getUseColumns(CommandLine result) {
        List<String> columnNames = CommandUtil.getColumnNames(result);
        if (columnNames == null) {
            return null;
        }
        return StringUtils.join(columnNames, ",");
    }

    private static boolean getWhereInEnabled(CommandLine result) {
        return result.hasOption("in");
    }

    private static boolean getReadAndProcessFileOnly(CommandLine result) {
        return result.hasOption("rfonly");
    }

    private static String getDbName(CommandLine result) {
        return result.getOptionValue("D");
    }

    private static int getConsumerParallelism(CommandLine result) {
        if (result.hasOption("con")) {
            int parallelism = Integer.parseInt(result.getOptionValue("con"));
            if (parallelism <= 0) {
                throw new IllegalArgumentException("Consumer parallelism should be > 0");
            }
            return parallelism;
        }
        return ConfigConstant.DEFAULT_CONSUMER_SIZE;
    }

    private static int getProducerParallelism(CommandLine result) {
        if (result.hasOption("pro")) {
            int parallelism = Integer.parseInt(result.getOptionValue("pro"));
            if (parallelism <= 0) {
                throw new IllegalArgumentException("Producer parallelism should be > 0");
            }
            return parallelism;
        }
        return 4;
    }

    private static QuoteEncloseMode getQuoteEncloseMode(CommandLine result) {
        if (result.hasOption("quote")) {
            return QuoteEncloseMode.parseMode(result.getOptionValue("quote"));
        }
        return ConfigConstant.DEFAULT_QUOTE_ENCLOSE_MODE;
    }

    private static BenchmarkMode getBenchmarkMode(CommandLine result) {
        if (result.hasOption("benchmark")) {
            return BenchmarkMode.parseMode(result.getOptionValue("benchmark"));
        }
        return BenchmarkMode.NONE;
    }

    private static int getScale(CommandLine result) {
        if (result.hasOption("scale")) {
            return Integer.parseInt(result.getOptionValue("scale"));
        }
        return 0;
    }

    private static boolean getForceParallelism(CommandLine result) {
        if (result.hasOption("fcon")) {
            return Boolean.parseBoolean(result.getOptionValue("fcon"));
        }
        return false;
    }

    private static List<FileLineRecord> getFileRecordList(CommandLine result) {
        if (result.hasOption("f")) {
            String filePathListStr = result.getOptionValue("f");
            return Arrays.stream(StringUtils.split(filePathListStr, ";")).filter(StringUtils::isNotBlank).map(s2 -> {
                String[] strs = StringUtils.split(s2, ":");
                if (strs.length == 1) {
                    String fileAbsPath = FileUtil.getFileAbsPath(strs[0]);
                    return new FileLineRecord(fileAbsPath);
                }
                if (strs.length == 2) {
                    String fileAbsPath = FileUtil.getFileAbsPath(strs[0]);
                    int startLine = Integer.parseInt(strs[1]);
                    return new FileLineRecord(fileAbsPath, startLine);
                }
                throw new IllegalArgumentException("Illegal file: " + s2);
            }).collect(Collectors.toList());
        }
        if (result.hasOption("dir")) {
            String dirPathStr = result.getOptionValue("dir");
            List<String> filePaths = FileUtil.getFilesAbsPathInDir(dirPathStr);
            return FileLineRecord.fromFilePaths(filePaths);
        }
        if (result.hasOption("benchmark")) {
            return null;
        }
        throw new IllegalStateException("cannot get file path list");
    }

    private static int getTpsLimit(CommandLine result) {
        if (result.hasOption("tps")) {
            int tpsLimit = Integer.parseInt(result.getOptionValue("tps"));
            if (tpsLimit <= 0) {
                throw new IllegalArgumentException("tps limit should be > 0");
            }
            return tpsLimit;
        }
        return -1;
    }

    private static boolean getInsertIgnoreAndResumeEnabled(CommandLine result) {
        return result.hasOption("i");
    }

    private static DdlMode getDdlMode(CommandLine result) {
        if (!result.hasOption("DDL")) {
            return DdlMode.NO_DDL;
        }
        return DdlMode.fromString(result.getOptionValue("DDL"));
    }

    private static int getMaxErrorCount(CommandLine result) {
        if (result.hasOption("error")) {
            return Integer.parseInt(result.getOptionValue("error"));
        }
        return 0;
    }

    private static String getHistoryFile(CommandLine result) {
        if (result.hasOption("H")) {
            return result.getOptionValue("H");
        }
        return null;
    }

    private static String getWhereCondition(CommandLine result) {
        return result.getOptionValue("w");
    }

    private static boolean getSqlEscapeEnabled(CommandLine result) {
        return !result.hasOption("noesc");
    }

    private static boolean getFuncEnabled(CommandLine result) {
        return result.hasOption("func");
    }

    private static void setRingBufferSize(CommandLine result) {
        if (result.hasOption("ringsize")) {
            int size = Integer.parseInt(result.getOptionValue("ringsize"));
            if (Integer.bitCount(size) != 1) {
                throw new IllegalArgumentException("Ring buffer size should be power of 2");
            }
            GlobalVar.DEFAULT_RING_BUFFER_SIZE = size;
        }
    }

    private static void setBatchSize(CommandLine result) {
        if (result.hasOption("batchsize")) {
            GlobalVar.EMIT_BATCH_SIZE = Integer.parseInt(result.getOptionValue("batchsize"));
        }
    }

    private static void setPerfMode(CommandLine result) {
        GlobalVar.IN_PERF_MODE = result.hasOption("perf");
    }

    private static void requireArg(CommandLine result, String argShort) {
        if (!result.hasOption(argShort)) {
            throw new IllegalArgumentException("Missing required argument: " + argShort);
        }
    }

    private static void requireOnlyOneArg(CommandLine result, String ... argsShort) {
        boolean contains = false;
        for (String arg : argsShort) {
            if (!result.hasOption(arg)) continue;
            if (contains) {
                throw new IllegalArgumentException("can only exists one of these arguments: " + StringUtils.join((Object[])argsShort, ", "));
            }
            contains = true;
        }
        if (!contains) {
            throw new IllegalArgumentException("Missing one of these arguments: " + StringUtils.join((Object[])argsShort, ", "));
        }
    }

    private static void addBatchOperationOptions(Options options) {
        options.addOption(Option.builder("o").longOpt("operation").hasArg().argName("operation").desc("Batch operation type: export / import / delete / update.").build());
        options.addOption(Option.builder("t").longOpt("table").hasArg().argName("table").desc("Target table.").build());
        options.addOption(Option.builder("s").longOpt("sep").hasArg().argName("sep").desc("Separator between fields (delimiter).").build());
        options.addOption(Option.builder("pre").longOpt("prefix").hasArg().argName("prefix").desc("Export file name prefix.").build());
        options.addOption(Option.builder("f").longOpt("from").hasArg().argName("from").desc("Source file(s), separated by ; .").build());
        options.addOption(Option.builder("L").longOpt("line").hasArg().argName("line").desc("Max line limit of exported files.").build());
        options.addOption(Option.builder("F").longOpt("filenum").hasArg().argName("filenum").desc("Fixed number of exported files.").build());
        options.addOption(Option.builder("w").longOpt("where").hasArg().argName("where").desc("Where condition: col1>99 AND col2<100 ...").build());
        options.addOption(Option.builder("i").longOpt("ignoreandresume").argName("ignore").desc("Flag of insert ignore and resume breakpoint.").build());
        options.addOption(Option.builder("H").longOpt("historyFile").hasArg().argName("history file name").desc("Configure of historyfile name.").build());
        options.addOption(Option.builder("tps").longOpt("tpsLimit").hasArg().argName("tps limit").desc("Configure of tps limit, default -1: no limit.").build());
        options.addOption(Option.builder("pro").longOpt("producer").hasArg().argName("producer count").desc("Configure number of producer threads (export / import).").build());
        options.addOption(Option.builder("con").longOpt("consumer").hasArg().argName("consumer count").desc("Configure number of consumer threads.").build());
        options.addOption(Option.builder("fcon").longOpt("force consumer").hasArg().argName("use force consumer").desc("Configure if allow force consumer parallelism.").build());
        options.addOption(Option.builder("rfonly").longOpt("rfonly").desc("Only read and process file, no sql execution.").build());
        options.addOption(Option.builder("in").longOpt("wherein").desc("Using where ... in (...)").build());
        options.addOption(Option.builder("lastSep").longOpt("withLastSep").desc("Whether line ends with separator.").build());
        options.addOption(Option.builder("para").longOpt("paraMerge").desc("Using parallel merge when doing order by export.").build());
        options.addOption(Option.builder("header").longOpt("header").desc("Whether the header line is column names.").build());
        options.addOption(Option.builder("quote").longOpt("quoteMode").hasArg().argName("auto/force/none").desc("The mode of how field values are enclosed by double-quotes when exporting table. Default value is auto.").build());
        options.addOption(Option.builder("DDL").longOpt("DDL").hasArg().desc("Export or import with table definition DDL mode: NONE / ONLY / WITH").build());
        options.addOption(Option.builder("comp").longOpt("compress").hasArg().desc("Export or import compressed file: NONE / GZIP").build());
        options.addOption(Option.builder("enc").longOpt("encrypt").hasArg().desc("Export or import with encrypted file: NONE / AES-CBC").build());
        options.addOption(Option.builder("key").longOpt("key").hasArg().desc("Encryption key (string).").build());
        options.addOption(Option.builder("format").longOpt("fileformat").hasArg().desc("File format: NONE / TXT / CSV").build());
        options.addOption(Option.builder("error").longOpt("max-error").hasArg().desc("Max error count threshold.").build());
        options.addOption(Option.builder("perf").longOpt("perf").desc("perf mode").build());
        options.addOption(Option.builder("benchmark").longOpt("benchmark").hasArg().argName("none/tpch").desc("Fast loading benchmark data. Default value is none.").build());
        options.addOption(Option.builder("scale").longOpt("scale").hasArg().argName("size").desc("The size scale benchmark data (GB for tpch).").build());
    }

    private static void addConnectDbOptions(Options options) {
        options.addOption(Option.builder("h").longOpt("host").hasArg().argName("host").desc("Connect to host.").build());
        options.addOption(Option.builder("u").longOpt("user").hasArg().argName("user").desc("User for login.").build());
        options.addOption(Option.builder("p").longOpt("password").hasArg().argName("password").desc("Password to use when connecting to server.").build());
        options.addOption(Option.builder("P").longOpt("port").hasArg().argName("port").desc("Port number to use for connection.").build());
        options.addOption(Option.builder("D").longOpt("database").hasArg().argName("database").desc("Database to use.").build());
        options.addOption(Option.builder("lb").longOpt("loadbalance").argName("loadbalance").desc("If using load balance.").build());
        options.addOption(Option.builder("param").longOpt("connParam").hasArg().argName("params").desc("Connection params").build());
        options.addOption(Option.builder("O").longOpt("orderby").hasArg().argName("order by type").desc("asc or desc.").build());
        options.addOption(Option.builder("dir").longOpt("dir").hasArg().argName("directory").desc("Directory path including files to import.").build());
        options.addOption(Option.builder("cs").longOpt("charset").hasArg().argName("charset").desc("Define charset of files.").build());
        options.addOption(Option.builder("sharding").longOpt("sharding").hasArg().argName("on | off").desc("Enable sharding mode [on | off].").build());
        options.addOption(Option.builder("OC").longOpt("orderCol").hasArg().argName("ordered column").desc("col1;col2;col3").build());
        options.addOption(Option.builder("col").longOpt("columns").hasArg().argName("export columns").desc("col1;col2;col3").build());
        options.addOption(Option.builder("local").longOpt("localmerge").desc("Use local merge sort.").build());
        options.addOption(Option.builder("func").longOpt("sqlfunc").desc("Use sql function to update.").build());
        options.addOption(Option.builder("noesc").longOpt("noescape").desc("Don't escape values.").build());
        options.addOption(Option.builder("maxConn").longOpt("maxConnection").hasArg().desc("Max connection number limit.").build());
        options.addOption(Option.builder("minConn").longOpt("minConnection").hasArg().desc("Mim connection number limit.").build());
        options.addOption(Option.builder("maxWait").longOpt("connMaxWait").hasArg().desc("Max wait time(ms) when getting a connection.").build());
        options.addOption(Option.builder("initSqls").longOpt("initSqls").hasArg().desc("Connection init sqls.").build());
        options.addOption(Option.builder("batchsize").longOpt("batchSize").hasArg().desc("Batch size of emitted tuples.").build());
        options.addOption(Option.builder("readsize").longOpt("readSize").hasArg().desc("Read block size in MB.").build());
        options.addOption(Option.builder("ringsize").longOpt("ringBufferSize").hasArg().desc("Ring buffer size.").build());
    }

    public static void printHelp() {
        formatter.printHelp("BatchTool", options, true);
    }

    private static CommandType lookup(String commandType) {
        for (CommandType type : CommandType.values()) {
            if (!type.name().equalsIgnoreCase(commandType)) continue;
            return type;
        }
        throw new IllegalArgumentException("Do not support command " + commandType);
    }

    private static boolean parseFlag(String flag) {
        if (StringUtils.isEmpty(flag)) {
            return false;
        }
        if ((flag = StringUtils.strip(flag)).equalsIgnoreCase("ON") || flag.equalsIgnoreCase("TRUE")) {
            return true;
        }
        if (flag.equalsIgnoreCase("OFF") || flag.equalsIgnoreCase("FALSE")) {
            return false;
        }
        throw new IllegalArgumentException("Illegal flag string: " + flag + ". Should be ON or OFF");
    }

    public static boolean doHelpCmd(CommandLine commandLine) {
        if (CommandUtil.isShowHelp(commandLine)) {
            CommandUtil.printHelp();
            return true;
        }
        if (CommandUtil.isShowVersion(commandLine)) {
            System.out.printf("%s: %s%n", "BatchTool", Version.getVersion());
            return true;
        }
        return false;
    }

    private static boolean isShowHelp(CommandLine result) {
        return result.hasOption("help");
    }

    private static boolean isShowVersion(CommandLine result) {
        return result.hasOption("v");
    }

    static {
        CommandUtil.addConnectDbOptions(options);
        CommandUtil.addBatchOperationOptions(options);
        options.addOption(Option.builder("help").longOpt("help").desc("Help message.").build());
        options.addOption(Option.builder("v").longOpt("version").desc("Show version").build());
    }
}

