/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class SQLTimeExpr
extends SQLExprImpl
implements SQLLiteralExpr,
SQLValuableExpr,
SQLReplaceable {
    public static final SQLDataType DATA_TYPE = new SQLDataTypeImpl("time");
    private SQLExpr literal;
    public static long supportDbTypes = DbType.of(DbType.mysql, DbType.oracle, DbType.presto, DbType.trino, DbType.postgresql);

    public SQLTimeExpr() {
    }

    public SQLTimeExpr(Date now, TimeZone timeZone) {
        this.setLiteral(now, timeZone);
    }

    public void setLiteral(Date x, TimeZone timeZone) {
        if (x == null) {
            this.literal = null;
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        if (timeZone != null) {
            format.setTimeZone(timeZone);
        }
        String text = format.format(x);
        this.setLiteral(text);
    }

    public SQLTimeExpr(String literal) {
        this.setLiteral(literal);
    }

    public SQLExpr getLiteral() {
        return this.literal;
    }

    public void setLiteral(String literal) {
        this.setLiteral(new SQLCharExpr(literal));
    }

    public void setLiteral(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.literal = x;
    }

    @Override
    public SQLDataType computeDataType() {
        return DATA_TYPE;
    }

    @Override
    public String getValue() {
        if (this.literal instanceof SQLCharExpr) {
            return ((SQLCharExpr)this.literal).getText();
        }
        return null;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (this.literal == expr) {
            this.setLiteral(target);
            return true;
        }
        return false;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.literal == null ? 0 : this.literal.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLTimeExpr other = (SQLTimeExpr)obj;
        return !(this.literal == null ? other.literal != null : !this.literal.equals(other.literal));
    }

    @Override
    public SQLTimeExpr clone() {
        SQLTimeExpr x = new SQLTimeExpr();
        if (this.literal != null) {
            x.setLiteral(this.literal.clone());
        }
        return x;
    }

    @Override
    public List<SQLObject> getChildren() {
        return Collections.emptyList();
    }

    public static boolean isSupport(DbType dbType) {
        return (dbType.mask & supportDbTypes) != 0L;
    }

    public static boolean check(String str) {
        if (str == null || str.length() != 8) {
            return false;
        }
        if (str.charAt(2) != ':' && str.charAt(5) != ':') {
            return false;
        }
        char c0 = str.charAt(0);
        char c1 = str.charAt(1);
        char c3 = str.charAt(3);
        char c4 = str.charAt(4);
        char c6 = str.charAt(6);
        char c7 = str.charAt(7);
        if (c0 < '0' || c0 > '9') {
            return false;
        }
        if (c1 < '0' || c1 > '9') {
            return false;
        }
        if (c3 < '0' || c3 > '9') {
            return false;
        }
        if (c4 < '0' || c4 > '9') {
            return false;
        }
        if (c6 < '0' || c6 > '9') {
            return false;
        }
        if (c7 < '0' || c7 > '9') {
            return false;
        }
        int HH = (c0 - 48) * 10 + (c1 - 48);
        int mm3 = (c3 - 48) * 10 + (c4 - 48);
        int ss = (c6 - 48) * 10 + (c7 - 48);
        return HH <= 24 && mm3 <= 60 && ss <= 60;
    }
}

