/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.logging;

import com.alibaba.druid.support.logging.Log;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Jdk14LoggingImpl
implements Log {
    private Logger log;
    private int errorCount;
    private int warnCount;
    private int infoCount;
    private int debugCount;
    private String loggerName;

    public Jdk14LoggingImpl(String loggerName) {
        this.loggerName = loggerName;
        this.log = Logger.getLogger(loggerName);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isLoggable(Level.FINE);
    }

    @Override
    public void error(String s2, Throwable e) {
        this.log.logp(Level.SEVERE, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), s2, e);
        ++this.errorCount;
    }

    @Override
    public void error(String s2) {
        this.log.logp(Level.SEVERE, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), s2);
        ++this.errorCount;
    }

    @Override
    public void debug(String s2) {
        ++this.debugCount;
        this.log.logp(Level.FINE, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), s2);
    }

    @Override
    public void debug(String s2, Throwable e) {
        ++this.debugCount;
        this.log.logp(Level.FINE, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), s2, e);
    }

    @Override
    public void warn(String s2) {
        this.log.logp(Level.WARNING, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), s2);
        ++this.warnCount;
    }

    @Override
    public void warn(String s2, Throwable e) {
        this.log.logp(Level.WARNING, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), s2, e);
        ++this.warnCount;
    }

    @Override
    public int getWarnCount() {
        return this.warnCount;
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public void resetStat() {
        this.errorCount = 0;
        this.warnCount = 0;
        this.infoCount = 0;
        this.debugCount = 0;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isLoggable(Level.INFO);
    }

    @Override
    public void info(String msg) {
        this.log.logp(Level.INFO, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), msg);
        ++this.infoCount;
    }

    @Override
    public int getInfoCount() {
        return this.infoCount;
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isLoggable(Level.WARNING);
    }

    @Override
    public int getDebugCount() {
        return this.debugCount;
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log.isLoggable(Level.SEVERE);
    }
}

