/*
 * Decompiled with CFR 0.152.
 */
package datasource;

import util.DataSourceUtil;

public class DataSourceConfig {
    private String url;
    private String host;
    private String port;
    private String dbName;
    private String username;
    private String password;
    private int maxConnectionNum;
    private int minConnectionNum;
    private int maxWait;
    private String connParam;
    private String initSqls;
    private boolean loadBalanceEnabled;

    public int getMaxConnectionNum() {
        return this.maxConnectionNum;
    }

    public void setMaxConnectionNum(int maxConnectionNum) {
        this.maxConnectionNum = maxConnectionNum;
    }

    public int getMinConnectionNum() {
        return this.minConnectionNum;
    }

    public void setMinConnectionNum(int minConnectionNum) {
        this.minConnectionNum = minConnectionNum;
    }

    public String getConnParam() {
        return this.connParam;
    }

    public void setConnParam(String connParam) {
        this.connParam = connParam;
    }

    public int getMaxWait() {
        return this.maxWait;
    }

    public String getUrl() {
        return this.url;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getInitSqls() {
        return this.initSqls;
    }

    public String toString() {
        return "DataSourceConfig{url='" + this.url + '\'' + ", host='" + this.host + '\'' + ", port='" + this.port + '\'' + ", dbName='" + this.dbName + '\'' + ", username='" + this.username + '\'' + ", maxConnectionNum=" + this.maxConnectionNum + ", minConnectionNum=" + this.minConnectionNum + ", loadBalanceEnabled=" + this.loadBalanceEnabled + ", initSqls=" + this.initSqls + '}';
    }

    public static final class DataSourceConfigBuilder {
        private String host;
        private String port;
        private String dbName;
        private String username;
        private String password;
        private int minConnectionNum;
        private int maxConnectionNum;
        private int maxWait;
        private boolean loadBalanceEnabled;
        private String connParam;
        private String initSqls;

        public DataSourceConfigBuilder host(String host) {
            this.host = host;
            return this;
        }

        public DataSourceConfigBuilder port(String port) {
            this.port = port;
            return this;
        }

        public DataSourceConfigBuilder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public DataSourceConfigBuilder username(String username) {
            this.username = username;
            return this;
        }

        public DataSourceConfigBuilder loadBalanceEnabled(boolean loadBalanceEnabled) {
            this.loadBalanceEnabled = loadBalanceEnabled;
            return this;
        }

        public DataSourceConfigBuilder password(String password) {
            this.password = password;
            return this;
        }

        public DataSourceConfigBuilder maxWait(int maxWait) {
            this.maxWait = maxWait;
            return this;
        }

        public DataSourceConfigBuilder maxConnNumber(int connNumber) {
            this.maxConnectionNum = connNumber;
            return this;
        }

        public DataSourceConfigBuilder minConnNumber(int connNumber) {
            this.minConnectionNum = connNumber;
            return this;
        }

        public DataSourceConfigBuilder connParam(String connParam) {
            this.connParam = connParam;
            return this;
        }

        public DataSourceConfigBuilder initSqls(String initSqls) {
            this.initSqls = initSqls;
            return this;
        }

        public DataSourceConfig build() {
            DataSourceConfig dataSourceConfig = new DataSourceConfig();
            dataSourceConfig.username = this.username;
            dataSourceConfig.host = this.host;
            dataSourceConfig.password = this.password;
            dataSourceConfig.port = this.port;
            dataSourceConfig.dbName = this.dbName;
            dataSourceConfig.maxConnectionNum = this.maxConnectionNum;
            dataSourceConfig.minConnectionNum = this.minConnectionNum;
            dataSourceConfig.maxWait = this.maxWait;
            dataSourceConfig.connParam = this.connParam;
            dataSourceConfig.initSqls = this.initSqls;
            String jdbcUrl = this.loadBalanceEnabled ? String.format(DataSourceUtil.LOAD_BALANCE_URL_PATTERN, this.host, this.dbName) : String.format(DataSourceUtil.URL_PATTERN, this.host, this.port, this.dbName);
            if (this.connParam != null) {
                jdbcUrl = jdbcUrl + "&" + this.connParam;
            }
            dataSourceConfig.url = jdbcUrl;
            return dataSourceConfig;
        }
    }
}

