/*
 * Decompiled with CFR 0.152.
 */
package datasource;

import com.alibaba.druid.pool.DruidDataSource;
import datasource.DataSourceConfig;
import exception.DataSourceException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DruidSource {
    private static volatile DruidDataSource instance;
    private static DataSourceConfig dataSourceConfig;

    public static void setDataSourceConfig(DataSourceConfig dataSourceConfig) {
        DruidSource.dataSourceConfig = dataSourceConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DruidDataSource getInstance() throws DataSourceException {
        if (instance != null) return instance;
        Class<DruidSource> clazz = DruidSource.class;
        synchronized (DruidSource.class) {
            if (instance != null) return instance;
            if (dataSourceConfig == null) {
                throw new DataSourceException("Config uninitialized");
            }
            instance = new DruidDataSource();
            instance.setAsyncCloseConnectionEnable(true);
            instance.setUrl(dataSourceConfig.getUrl());
            instance.setUsername(dataSourceConfig.getUsername());
            instance.setPassword(dataSourceConfig.getPassword());
            instance.setInitialSize(dataSourceConfig.getMinConnectionNum());
            instance.setMinIdle(dataSourceConfig.getMinConnectionNum());
            instance.setMaxActive(dataSourceConfig.getMaxConnectionNum());
            instance.setConnectionInitSqls(DruidSource.initSqlStrToList(dataSourceConfig.getInitSqls()));
            instance.setMaxWait(dataSourceConfig.getMaxWait());
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static List<String> initSqlStrToList(String initSqls) {
        ArrayList<String> initSqlList = new ArrayList<String>();
        if (initSqls != null && !StringUtils.isEmpty(initSqls)) {
            char sc = initSqls.charAt(0);
            char ec = initSqls.charAt(initSqls.length() - 1);
            String newInitSqls = initSqls;
            if (sc == '\"' && ec == '\"' || sc == '\'' && ec == '\'' || sc == '`' && ec == '`') {
                newInitSqls = initSqls.substring(1, initSqls.length() - 1);
            }
            String[] initSqlListItem = newInitSqls.trim().split(";");
            for (int i = 0; i < initSqlListItem.length; ++i) {
                if (StringUtils.isEmpty(initSqlListItem[i])) continue;
                initSqlList.add(initSqlListItem[i]);
            }
        }
        return initSqlList;
    }
}

