/*
 * Decompiled with CFR 0.152.
 */
package exec;

import cmd.BaseOperateCommand;
import cmd.DeleteCommand;
import cmd.ExportCommand;
import cmd.ImportCommand;
import cmd.UpdateCommand;
import com.alibaba.druid.pool.DruidDataSource;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WorkerPool;
import datasource.DataSourceConfig;
import exception.DatabaseException;
import exec.ImportExecutor;
import exec.export.OrderByExportExecutor;
import exec.export.ShardingExportExecutor;
import exec.export.SingleThreadExportExecutor;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import model.ConsumerExecutionContext;
import model.ProducerExecutionContext;
import model.config.ConfigConstant;
import model.config.ExportConfig;
import model.config.FileLineRecord;
import model.config.GlobalVar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.DbUtil;
import worker.MyThreadPool;
import worker.MyWorkerPool;
import worker.common.BaseWorkHandler;
import worker.common.BatchLineEvent;
import worker.common.ReadFileProducer;
import worker.common.ReadFileWithBlockProducer;

public abstract class BaseExecutor {
    private static final Logger logger = LoggerFactory.getLogger(BaseExecutor.class);
    private final DataSourceConfig dataSourceConfig;
    protected final DataSource dataSource;
    protected final BaseOperateCommand command;

    public BaseExecutor(DataSourceConfig dataSourceConfig, DataSource dataSource, BaseOperateCommand baseCommand) {
        this.dataSourceConfig = dataSourceConfig;
        this.dataSource = dataSource;
        this.command = baseCommand;
    }

    public void preCheck() {
    }

    protected void checkTableExists(List<String> tableNames) {
        for (String tableName : tableNames) {
            try {
                Connection connection = this.dataSource.getConnection();
                try {
                    if (DbUtil.checkTableExists(connection, tableName)) continue;
                    throw new RuntimeException(String.format("Table [%s] does not exist", tableName));
                }
                finally {
                    if (connection == null) continue;
                    connection.close();
                }
            }
            catch (DatabaseException | SQLException e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public abstract void execute();

    public static BaseExecutor getExecutor(BaseOperateCommand command, DataSourceConfig dataSourceConfig, DruidDataSource druid) {
        if (command instanceof ExportCommand) {
            return BaseExecutor.getExportExecutor(dataSourceConfig, druid, (ExportCommand)command);
        }
        if (command instanceof ImportCommand) {
            return new ImportExecutor(dataSourceConfig, druid, command);
        }
        if (command instanceof UpdateCommand) {
            throw new UnsupportedOperationException();
        }
        if (command instanceof DeleteCommand) {
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    private static BaseExecutor getExportExecutor(DataSourceConfig dataSourceConfig, DruidDataSource druid, ExportCommand command) {
        ExportConfig config = command.getExportConfig();
        if (config.getOrderByColumnNameList() != null) {
            return new OrderByExportExecutor(dataSourceConfig, druid, (BaseOperateCommand)command);
        }
        if (command.isShardingEnabled()) {
            return new ShardingExportExecutor(dataSourceConfig, druid, (BaseOperateCommand)command);
        }
        return new SingleThreadExportExecutor(dataSourceConfig, druid, (BaseOperateCommand)command);
    }

    protected void configureCommonContextAndRun(Class<? extends BaseWorkHandler> clazz, ProducerExecutionContext producerExecutionContext, ConsumerExecutionContext consumerExecutionContext, String tableName) {
        this.configureCommonContextAndRun(clazz, producerExecutionContext, consumerExecutionContext, tableName, true);
    }

    protected void configureCommonContextAndRun(Class<? extends BaseWorkHandler> clazz, ProducerExecutionContext producerExecutionContext, ConsumerExecutionContext consumerExecutionContext, String tableName, boolean usingBlockReader) {
        List<FileLineRecord> fileLineRecordList = this.getFileRecordList(producerExecutionContext.getFileLineRecordList(), tableName);
        if (!usingBlockReader) {
            producerExecutionContext.setParallelism(fileLineRecordList.size());
        }
        ThreadPoolExecutor producerThreadPool = MyThreadPool.createExecutorWithEnsure(clazz.getName() + "-producer", producerExecutionContext.getParallelism());
        producerExecutionContext.setProducerExecutor(producerThreadPool);
        CountDownLatch countDownLatch = new CountDownLatch(producerExecutionContext.getParallelism());
        AtomicInteger emittedDataCounter = new AtomicInteger(0);
        ArrayList<ConcurrentHashMap<Long, AtomicInteger>> eventCounter = new ArrayList<ConcurrentHashMap<Long, AtomicInteger>>();
        for (int i = 0; i < producerExecutionContext.getFileLineRecordList().size(); ++i) {
            eventCounter.add(new ConcurrentHashMap(16));
        }
        producerExecutionContext.setEmittedDataCounter(emittedDataCounter);
        producerExecutionContext.setCountDownLatch(countDownLatch);
        producerExecutionContext.setEventCounter(eventCounter);
        int consumerNum = this.getConsumerNum(consumerExecutionContext);
        consumerExecutionContext.setParallelism(consumerNum);
        consumerExecutionContext.setDataSource(this.dataSource);
        consumerExecutionContext.setEmittedDataCounter(emittedDataCounter);
        consumerExecutionContext.setEventCounter(eventCounter);
        consumerExecutionContext.setUseBlock(usingBlockReader);
        consumerExecutionContext.setBatchTpsLimitPerConsumer((double)consumerExecutionContext.getTpsLimit() / (double)(consumerNum * GlobalVar.EMIT_BATCH_SIZE));
        ThreadPoolExecutor consumerThreadPool = MyThreadPool.createExecutorWithEnsure(clazz.getName() + "-consumer", consumerNum);
        EventFactory<BatchLineEvent> factory = BatchLineEvent::new;
        RingBuffer<BatchLineEvent> ringBuffer = MyWorkerPool.createRingBuffer(factory);
        if (!usingBlockReader) {
            throw new UnsupportedOperationException();
        }
        ReadFileWithBlockProducer producer = new ReadFileWithBlockProducer(producerExecutionContext, ringBuffer, fileLineRecordList);
        consumerExecutionContext.setUseMagicSeparator(producer.useMagicSeparator());
        producerExecutionContext.checkAndSetContextString(producerExecutionContext.toString() + consumerExecutionContext.toString());
        BaseWorkHandler[] consumers = new BaseWorkHandler[consumerNum];
        try {
            for (int i = 0; i < consumerNum; ++i) {
                consumers[i] = clazz.newInstance();
                consumers[i].setConsumerContext(consumerExecutionContext);
                consumers[i].createTpsLimiter(consumerExecutionContext.getBatchTpsLimitPerConsumer());
                consumers[i].setTableName(tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
        logger.debug("producer config {}", (Object)producerExecutionContext);
        logger.debug("consumer config {}", (Object)consumerExecutionContext);
        WorkerPool<BatchLineEvent> workerPool = MyWorkerPool.createWorkerPool(ringBuffer, consumers);
        workerPool.start(consumerThreadPool);
        try {
            ((ReadFileProducer)producer).produce();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            System.exit(1);
        }
        if (usingBlockReader && consumerExecutionContext.isInsertIgnoreAndResumeEnabled() && !consumerExecutionContext.isReadProcessFileOnly()) {
            this.checkConsumeProgress(producer, consumers);
        }
        this.waitForFinish(countDownLatch, emittedDataCounter, producerExecutionContext, consumerExecutionContext);
        workerPool.drainAndHalt();
        consumerThreadPool.shutdown();
        producerThreadPool.shutdown();
    }

    protected int getConsumerNum(ConsumerExecutionContext consumerExecutionContext) {
        if (!consumerExecutionContext.isForceParallelism()) {
            return Math.max(consumerExecutionContext.getParallelism(), ConfigConstant.CPU_NUM);
        }
        return consumerExecutionContext.getParallelism();
    }

    private List<FileLineRecord> getFileRecordList(List<FileLineRecord> allFilePathList, String tableName) {
        if (allFilePathList == null || allFilePathList.isEmpty()) {
            throw new IllegalArgumentException("File path list cannot be empty");
        }
        if (allFilePathList.size() == 1) {
            return allFilePathList;
        }
        List<FileLineRecord> fileRecordList = allFilePathList.stream().filter(fileRecord -> {
            int i;
            String fileName = new File(fileRecord.getFilePath()).getName();
            if (fileName.length() < tableName.length() + 2) {
                return false;
            }
            for (i = 0; i < tableName.length(); ++i) {
                if (tableName.charAt(i) == fileName.charAt(i)) continue;
                return false;
            }
            if (fileName.charAt(i) == '.') {
                return true;
            }
            if (fileName.charAt(i++) != '_') {
                return false;
            }
            while (i < fileName.length()) {
                if (!Character.isDigit(fileName.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }).collect(Collectors.toList());
        if (fileRecordList.isEmpty()) {
            throw new IllegalArgumentException("No filename with suffix starts with table name: " + tableName);
        }
        return fileRecordList;
    }

    protected void waitForFinish(CountDownLatch countDownLatch, AtomicInteger emittedDataCounter) {
        try {
            int remain;
            countDownLatch.await();
            while ((remain = emittedDataCounter.get()) > 0) {
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.onWorkFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForFinish(CountDownLatch countDownLatch, AtomicInteger emittedDataCounter, ProducerExecutionContext producerContext, ConsumerExecutionContext consumerContext) {
        try {
            int remain;
            while (!countDownLatch.await(3L, TimeUnit.SECONDS)) {
                if (producerContext.getException() != null) {
                    logger.warn("Early exit because of producer exception");
                    return;
                }
                if (consumerContext.getException() == null) continue;
                logger.warn("Early exit because of consumer exception");
                return;
            }
            while ((remain = emittedDataCounter.get()) > 0) {
                if (consumerContext.getException() != null) {
                    logger.warn("Early exit because of consumer exception");
                    return;
                }
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.onWorkFinished();
        }
    }

    protected void checkConsumeProgress(ReadFileWithBlockProducer producers, BaseWorkHandler[] consumers) {
    }

    protected void onWorkFinished() {
    }

    public void close() {
    }

    protected String getSchemaName() {
        return this.dataSourceConfig.getDbName();
    }
}

