/*
 * Decompiled with CFR 0.152.
 */
package exec;

import cmd.BaseOperateCommand;
import com.alibaba.druid.pool.DruidDataSource;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WorkerPool;
import datasource.DataSourceConfig;
import exception.DatabaseException;
import exec.WriteDbExecutor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import model.config.BenchmarkMode;
import model.config.DdlMode;
import model.config.GlobalVar;
import model.config.QuoteEncloseMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.DbUtil;
import worker.MyThreadPool;
import worker.MyWorkerPool;
import worker.ddl.DdlImporter;
import worker.insert.ImportConsumer;
import worker.insert.ProcessOnlyImportConsumer;
import worker.insert.ShardedImportConsumer;
import worker.tpch.BatchInsertSqlEvent;
import worker.tpch.TpchConsumer;
import worker.tpch.TpchProducer;

public class ImportExecutor
extends WriteDbExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ImportExecutor.class);

    public ImportExecutor(DataSourceConfig dataSourceConfig, DruidDataSource druid, BaseOperateCommand baseCommand) {
        super(dataSourceConfig, druid, baseCommand);
    }

    @Override
    public void preCheck() {
        block13: {
            if (this.producerExecutionContext.getDdlMode() != DdlMode.NO_DDL) {
                if (this.command.isDbOperation()) {
                    this.checkDbNotExist(this.command.getDbName());
                } else {
                    this.checkTableNotExist(this.command.getTableNames());
                }
            } else {
                if (this.command.isDbOperation()) {
                    try (Connection conn = this.dataSource.getConnection();){
                        this.tableNames = DbUtil.getAllTablesInDb(conn, this.command.getDbName());
                        break block13;
                    }
                    catch (DatabaseException | SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.checkTableExists(this.command.getTableNames());
                this.tableNames = this.command.getTableNames();
            }
        }
    }

    private void checkDbNotExist(String dbName) {
        if ("polardbx".equalsIgnoreCase(dbName)) {
            return;
        }
        try (Connection conn = this.dataSource.getConnection();){
            if (DbUtil.checkDatabaseExists(conn, dbName)) {
                throw new RuntimeException(String.format("Database [%s] already exists, cannot import with ddl", dbName));
            }
        }
        catch (DatabaseException | SQLException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private void checkTableNotExist(List<String> tableNames) {
        for (String tableName : tableNames) {
            try {
                Connection conn = this.dataSource.getConnection();
                try {
                    if (!DbUtil.checkTableExists(conn, tableName)) continue;
                    throw new RuntimeException(String.format("Table [%s] already exists, cannot import with ddl", tableNames));
                }
                finally {
                    if (conn == null) continue;
                    conn.close();
                }
            }
            catch (DatabaseException | SQLException e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    @Override
    public void execute() {
        if (this.producerExecutionContext.getBenchmarkMode() != BenchmarkMode.NONE) {
            this.handleBenchmark(this.tableNames);
            return;
        }
        switch (this.producerExecutionContext.getDdlMode()) {
            case WITH_DDL: {
                this.handleDDL();
                break;
            }
            case DDL_ONLY: {
                this.handleDDL();
                return;
            }
            case NO_DDL: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("DDL mode is not supported: " + (Object)((Object)this.producerExecutionContext.getDdlMode()));
            }
        }
        this.configureFieldMetaInfo();
        for (String tableName : this.tableNames) {
            if (this.producerExecutionContext.isSingleThread() && this.consumerExecutionContext.isSingleThread()) {
                this.doSingleThreadImport(tableName);
            } else if (this.command.isShardingEnabled()) {
                this.doShardingImport(tableName);
            } else {
                this.doDefaultImport(tableName);
            }
            if (this.producerExecutionContext.getException() != null) {
                logger.error("Load data into {} failed\uff1a{}", (Object)tableName, (Object)this.producerExecutionContext.getException().getMessage());
                return;
            }
            if (this.consumerExecutionContext.getException() != null) {
                logger.error("Load data into {} failed\uff1a{}", (Object)tableName, (Object)this.consumerExecutionContext.getException().getMessage());
                return;
            }
            logger.info("Load data into {} done", (Object)tableName);
        }
    }

    private void handleBenchmark(List<String> tableNames) {
        switch (this.producerExecutionContext.getBenchmarkMode()) {
            case TPCH: {
                this.handleTpchImport(tableNames);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not support " + (Object)((Object)this.producerExecutionContext.getBenchmarkMode()));
            }
        }
    }

    private void handleTpchImport(List<String> tableNames) {
        int producerParallelism = this.producerExecutionContext.getParallelism();
        AtomicInteger emittedDataCounter = new AtomicInteger(0);
        ThreadPoolExecutor producerThreadPool = MyThreadPool.createExecutorExact(TpchProducer.class.getSimpleName(), producerParallelism);
        this.producerExecutionContext.setProducerExecutor(producerThreadPool);
        this.producerExecutionContext.setEmittedDataCounter(emittedDataCounter);
        int consumerParallelism = this.getConsumerNum(this.consumerExecutionContext);
        this.consumerExecutionContext.setParallelism(consumerParallelism);
        this.consumerExecutionContext.setDataSource(this.dataSource);
        this.consumerExecutionContext.setEmittedDataCounter(emittedDataCounter);
        ThreadPoolExecutor consumerThreadPool = MyThreadPool.createExecutorExact(TpchConsumer.class.getSimpleName(), consumerParallelism);
        EventFactory<BatchInsertSqlEvent> factory = BatchInsertSqlEvent::new;
        RingBuffer<BatchInsertSqlEvent> ringBuffer = MyWorkerPool.createRingBuffer(factory);
        TpchProducer tpchProducer = new TpchProducer(this.producerExecutionContext, tableNames, ringBuffer);
        CountDownLatch countDownLatch = new CountDownLatch(tpchProducer.getWorkerCount());
        this.producerExecutionContext.setCountDownLatch(countDownLatch);
        TpchConsumer[] consumers = new TpchConsumer[consumerParallelism];
        try {
            for (int i = 0; i < consumerParallelism; ++i) {
                consumers[i] = new TpchConsumer(this.consumerExecutionContext);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
        logger.debug("producer config {}", (Object)this.producerExecutionContext);
        logger.debug("consumer config {}", (Object)this.consumerExecutionContext);
        WorkerPool<BatchInsertSqlEvent> workerPool = MyWorkerPool.createWorkerPool(ringBuffer, consumers);
        workerPool.start(consumerThreadPool);
        try {
            tpchProducer.produce();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
        this.waitForFinish(countDownLatch, emittedDataCounter, this.producerExecutionContext, this.consumerExecutionContext);
        if (this.producerExecutionContext.getException() != null || this.consumerExecutionContext.getException() != null) {
            producerThreadPool.shutdownNow();
            consumerThreadPool.shutdownNow();
            workerPool.halt();
        } else {
            workerPool.drainAndHalt();
            consumerThreadPool.shutdown();
            producerThreadPool.shutdown();
        }
    }

    private void handleDDL() {
        DdlImporter ddlImporter;
        if (this.command.isDbOperation()) {
            if (this.producerExecutionContext.getFileLineRecordList().size() != 1) {
                throw new UnsupportedOperationException("Import database DDL only support one ddl file now!");
            }
            ddlImporter = new DdlImporter(this.producerExecutionContext.getFileLineRecordList().get(0).getFilePath(), this.dataSource);
        } else {
            ddlImporter = new DdlImporter(this.command.getTableNames(), this.dataSource);
        }
        ddlImporter.doImportSync();
    }

    private void doSingleThreadImport(String tableName) {
        throw new UnsupportedOperationException();
    }

    private void doDefaultImport(String tableName) {
        if (this.consumerExecutionContext.isReadProcessFileOnly()) {
            this.configureCommonContextAndRun(ProcessOnlyImportConsumer.class, this.producerExecutionContext, this.consumerExecutionContext, tableName);
        } else {
            this.configureCommonContextAndRun(ImportConsumer.class, this.producerExecutionContext, this.consumerExecutionContext, tableName, this.useBlockReader());
        }
    }

    private void doShardingImport(String tableName) {
        this.configurePartitionKey();
        this.configureTopology();
        this.configureCommonContextAndRun(ShardedImportConsumer.class, this.producerExecutionContext, this.consumerExecutionContext, tableName, this.useBlockReader());
    }

    private boolean useBlockReader() {
        if (GlobalVar.IN_PERF_MODE) {
            return true;
        }
        if (this.producerExecutionContext.getQuoteEncloseMode() == QuoteEncloseMode.FORCE) {
            return false;
        }
        if (!this.producerExecutionContext.getEncryptionConfig().getEncryptionMode().isSupportStreamingBit()) {
            return false;
        }
        return this.producerExecutionContext.getFileFormat().isSupportBlock();
    }
}

