/*
 * Decompiled with CFR 0.152.
 */
package exec;

import cmd.BaseOperateCommand;
import cmd.WriteDbCommand;
import com.alibaba.druid.pool.DruidDataSource;
import datasource.DataSourceConfig;
import exception.DatabaseException;
import exec.BaseExecutor;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import model.ConsumerExecutionContext;
import model.ProducerExecutionContext;
import model.db.PartitionKey;
import model.db.PrimaryKey;
import model.db.TableFieldMetaInfo;
import model.db.TableTopology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.DbUtil;
import worker.common.BaseWorkHandler;
import worker.common.ReadFileWithBlockProducer;

public abstract class WriteDbExecutor
extends BaseExecutor {
    private static final Logger logger = LoggerFactory.getLogger(WriteDbExecutor.class);
    protected ProducerExecutionContext producerExecutionContext;
    protected ConsumerExecutionContext consumerExecutionContext;
    protected List<String> tableNames;

    public WriteDbExecutor(DataSourceConfig dataSourceConfig, DruidDataSource druid, BaseOperateCommand baseCommand) {
        super(dataSourceConfig, druid, baseCommand);
        WriteDbCommand writeDbCommand = (WriteDbCommand)baseCommand;
        this.producerExecutionContext = writeDbCommand.getProducerExecutionContext();
        this.consumerExecutionContext = writeDbCommand.getConsumerExecutionContext();
        this.tableNames = this.consumerExecutionContext.getTableNames();
    }

    protected void configurePkList() {
        HashMap<String, List<PrimaryKey>> tablePkList = new HashMap<String, List<PrimaryKey>>();
        for (String tableName : this.tableNames) {
            List<PrimaryKey> pkList = null;
            try {
                pkList = DbUtil.getPkList(this.dataSource.getConnection(), this.getSchemaName(), tableName);
                tablePkList.put(tableName, pkList);
            }
            catch (DatabaseException | SQLException e) {
                logger.error(e.getMessage());
                throw new RuntimeException(e);
            }
        }
        this.consumerExecutionContext.setTablePkList(tablePkList);
    }

    protected void configureFieldMetaInfo() {
        logger.info("Fetching meta data of all tables...");
        HashMap<String, TableFieldMetaInfo> tableFieldMetaInfoMap = null;
        try {
            if (this.command.getColumnNames() != null) {
                assert (this.tableNames.size() == 1);
                tableFieldMetaInfoMap = new HashMap();
                TableFieldMetaInfo fieldMetaInfo = DbUtil.getTableFieldMetaInfo(this.dataSource.getConnection(), this.getSchemaName(), this.tableNames.get(0), this.command.getColumnNames());
                tableFieldMetaInfoMap.put(this.tableNames.get(0), fieldMetaInfo);
            } else {
                tableFieldMetaInfoMap = DbUtil.getDbFieldMetaInfo(this.dataSource.getConnection(), this.getSchemaName(), this.tableNames);
            }
        }
        catch (DatabaseException | SQLException e) {
            logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
        this.consumerExecutionContext.setTableFieldMetaInfo(tableFieldMetaInfoMap);
        logger.info("Fetching meta data done");
    }

    protected void configureTopology() {
        HashMap<String, List<TableTopology>> tableTopologyMap = new HashMap<String, List<TableTopology>>();
        for (String tableName : this.tableNames) {
            List<TableTopology> topologyList = null;
            try {
                topologyList = DbUtil.getTopology(this.dataSource.getConnection(), tableName);
                tableTopologyMap.put(tableName, topologyList);
            }
            catch (DatabaseException | SQLException e) {
                logger.error(e.getMessage());
                throw new RuntimeException(e);
            }
        }
        this.consumerExecutionContext.setTopologyList(tableTopologyMap);
    }

    protected void configurePartitionKey() {
        HashMap<String, PartitionKey> tablePartitionKey = new HashMap<String, PartitionKey>();
        for (String tableName : this.tableNames) {
            PartitionKey partitionKey = null;
            try {
                partitionKey = DbUtil.getPartitionKey(this.dataSource.getConnection(), this.getSchemaName(), tableName);
                logger.info("\u8868 {} \u4f7f\u7528\u5206\u7247\u952e {}", (Object)tableName, (Object)partitionKey);
                tablePartitionKey.put(tableName, partitionKey);
            }
            catch (DatabaseException | SQLException e) {
                logger.error(e.getMessage());
                throw new RuntimeException(e);
            }
        }
        this.consumerExecutionContext.setTablePartitionKey(tablePartitionKey);
    }

    @Override
    protected void checkConsumeProgress(ReadFileWithBlockProducer producers, BaseWorkHandler[] consumers) {
        ScheduledThreadPoolExecutor checkConsumePartFinishScheduler = new ScheduledThreadPoolExecutor(1, r -> new Thread(r, "[check-progress-thread]"));
        checkConsumePartFinishScheduler.scheduleAtFixedRate(() -> {
            AtomicBoolean[] produceProgress = producers.getFileDoneList();
            for (int i = this.producerExecutionContext.getNextFileIndex(); i < produceProgress.length; ++i) {
                long nextDoBlockIndex = Long.MAX_VALUE;
                ConcurrentHashMap<Long, AtomicInteger> fileDone = this.producerExecutionContext.getEventCounter().get(i);
                for (Map.Entry<Long, AtomicInteger> entry : fileDone.entrySet()) {
                    if (entry.getValue().get() <= 0) continue;
                    nextDoBlockIndex = nextDoBlockIndex > entry.getKey() ? entry.getKey() : nextDoBlockIndex;
                }
                if (nextDoBlockIndex == Long.MAX_VALUE) {
                    if (produceProgress[i].get()) {
                        if (i + 1 != produceProgress.length) continue;
                        logger.info("\u6240\u6709\u6587\u4ef6\u5904\u7406\u5b8c\u6bd5");
                        continue;
                    }
                    this.producerExecutionContext.setNextFileIndex(i);
                    this.producerExecutionContext.setNextBlockIndex(0L);
                    break;
                }
                this.producerExecutionContext.setNextFileIndex(i);
                this.producerExecutionContext.setNextBlockIndex(nextDoBlockIndex);
                break;
            }
            this.producerExecutionContext.saveToHistoryFile(false);
            logger.info("\u4e0b\u4e00\u4e2a\u6587\u4ef6 {}", (Object)this.producerExecutionContext.getNextFileIndex());
            logger.info("\u4e0b\u4e00\u6570\u636e\u5757 {}", (Object)this.producerExecutionContext.getNextBlockIndex());
        }, 30L, 60L, TimeUnit.SECONDS);
        checkConsumePartFinishScheduler.shutdown();
    }

    @Override
    protected void onWorkFinished() {
        this.producerExecutionContext.saveToHistoryFile(true);
    }
}

