/*
 * Decompiled with CFR 0.152.
 */
package exec.export;

import cmd.BaseOperateCommand;
import cmd.ExportCommand;
import com.alibaba.druid.pool.DruidDataSource;
import datasource.DataSourceConfig;
import exec.BaseExecutor;
import model.config.ExportConfig;
import worker.ddl.DdlExportWorker;

public abstract class BaseExportExecutor
extends BaseExecutor {
    protected ExportConfig config;

    public BaseExportExecutor(DataSourceConfig dataSourceConfig, DruidDataSource druid, BaseOperateCommand baseCommand) {
        super(dataSourceConfig, druid, baseCommand);
        this.config = ((ExportCommand)this.command).getExportConfig();
    }

    @Override
    public void preCheck() {
        if (!this.command.isDbOperation()) {
            this.checkTableExists(this.command.getTableNames());
        }
    }

    @Override
    public void execute() {
        Thread ddlThread = null;
        switch (this.config.getDdlMode()) {
            case NO_DDL: {
                this.exportData();
                break;
            }
            case WITH_DDL: {
                ddlThread = this.exportDDL();
                this.exportData();
                break;
            }
            case DDL_ONLY: {
                ddlThread = this.exportDDL();
            }
        }
        if (ddlThread != null) {
            try {
                ddlThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private Thread exportDDL() {
        DdlExportWorker ddlExportWorker = this.command.isDbOperation() ? new DdlExportWorker(this.dataSource, this.command.getDbName()) : new DdlExportWorker(this.dataSource, this.command.getDbName(), this.command.getTableNames());
        Thread ddlThread = new Thread(ddlExportWorker);
        ddlThread.start();
        return ddlThread;
    }

    abstract void exportData();
}

