/*
 * Decompiled with CFR 0.152.
 */
package exec.export;

import cmd.BaseOperateCommand;
import cmd.ExportCommand;
import com.alibaba.druid.pool.DruidDataSource;
import datasource.DataSourceConfig;
import exception.DatabaseException;
import exec.export.BaseExportExecutor;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import model.config.ExportConfig;
import model.config.GlobalVar;
import model.db.FieldMetaInfo;
import model.db.TableFieldMetaInfo;
import model.db.TableTopology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.DbUtil;
import util.FileUtil;
import worker.MyThreadPool;
import worker.export.order.DirectOrderExportWorker;
import worker.export.order.LocalOrderByExportProducer;
import worker.export.order.OrderByExportProducer;
import worker.export.order.OrderByMergeExportConsumer;
import worker.export.order.ParallelMergeExportConsumer;
import worker.factory.ExportWorkerFactory;

public class OrderByExportExecutor
extends BaseExportExecutor {
    private static final Logger logger = LoggerFactory.getLogger(OrderByExportExecutor.class);
    private ExportConfig config;

    public OrderByExportExecutor(DataSourceConfig dataSourceConfig, DruidDataSource druid, BaseOperateCommand baseCommand) {
        super(dataSourceConfig, druid, baseCommand);
        this.config = ((ExportCommand)this.command).getExportConfig();
    }

    @Override
    void exportData() {
        this.handleExportOrderBy();
    }

    private void handleExportOrderBy() {
        if (!this.config.isLocalMerge()) {
            this.handleExportWithOrderByFromDb();
            return;
        }
        if (this.config.isParallelMerge()) {
            this.handleExportWithOrderByParallelMerge();
        } else {
            this.doExportWithOrderByLocal();
        }
    }

    private void doExportWithOrderByLocal() {
        for (String tableName : this.command.getTableNames()) {
            String filePathPrefix = FileUtil.getFilePathPrefix(this.config.getPath(), this.config.getFilenamePrefix(), tableName);
            try {
                OrderByMergeExportConsumer consumer;
                List<TableTopology> topologyList = DbUtil.getTopology(this.dataSource.getConnection(), tableName);
                TableFieldMetaInfo tableFieldMetaInfo = DbUtil.getTableFieldMetaInfo(this.dataSource.getConnection(), this.getSchemaName(), tableName);
                List<FieldMetaInfo> orderByColumnInfoList = DbUtil.getFieldMetaInfoListByColNames(this.dataSource.getConnection(), this.getSchemaName(), tableName, this.config.getOrderByColumnNameList());
                int shardSize = topologyList.size();
                ThreadPoolExecutor executor = MyThreadPool.createExecutorWithEnsure("BatchTool", shardSize);
                LinkedBlockingQueue[] orderedQueues = new LinkedBlockingQueue[shardSize];
                AtomicBoolean[] finishedList = new AtomicBoolean[shardSize];
                for (int i = 0; i < shardSize; ++i) {
                    orderedQueues[i] = new LinkedBlockingQueue(GlobalVar.DEFAULT_RING_BUFFER_SIZE);
                    finishedList[i] = new AtomicBoolean(false);
                    OrderByExportProducer orderByExportProducer = new OrderByExportProducer(this.dataSource, topologyList.get(i), tableFieldMetaInfo, orderedQueues[i], i, this.config.getOrderByColumnNameList(), finishedList[i]);
                    executor.submit(orderByExportProducer);
                }
                switch (this.config.getExportWay()) {
                    case MAX_LINE_NUM_IN_SINGLE_FILE: {
                        consumer = new OrderByMergeExportConsumer(filePathPrefix, this.config.getSeparator(), orderByColumnInfoList, orderedQueues, finishedList, this.config.getLimitNum());
                        break;
                    }
                    case FIXED_FILE_NUM: {
                        double totalRowCount = DbUtil.getTableRowCount(this.dataSource.getConnection(), tableName);
                        int fileNum = this.config.getLimitNum();
                        int singleLineLimit = (int)Math.ceil(totalRowCount / (double)fileNum);
                        consumer = new OrderByMergeExportConsumer(filePathPrefix, this.config.getSeparator(), orderByColumnInfoList, orderedQueues, finishedList, singleLineLimit);
                        break;
                    }
                    case DEFAULT: {
                        consumer = new OrderByMergeExportConsumer(filePathPrefix, this.config.getSeparator(), orderByColumnInfoList, orderedQueues, finishedList, 0);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported export exception");
                    }
                }
                try {
                    consumer.consume();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                executor.shutdown();
                logger.info("\u5bfc\u51fa {} \u6570\u636e\u5b8c\u6210", (Object)tableName);
            }
            catch (DatabaseException | SQLException e) {
                e.printStackTrace();
                logger.error(e.getMessage());
            }
        }
    }

    private void handleExportWithOrderByFromDb() {
        for (String tableName : this.command.getTableNames()) {
            try {
                TableFieldMetaInfo tableFieldMetaInfo = DbUtil.getTableFieldMetaInfo(this.dataSource.getConnection(), this.getSchemaName(), tableName);
                DirectOrderExportWorker directOrderByExportWorker = ExportWorkerFactory.buildDirectOrderExportWorker(this.dataSource, tableFieldMetaInfo, (ExportCommand)this.command, tableName);
                directOrderByExportWorker.exportSerially();
                logger.info("\u5bfc\u51fa {} \u6570\u636e\u5b8c\u6210", (Object)tableName);
            }
            catch (DatabaseException | SQLException e) {
                e.printStackTrace();
                logger.error(e.getMessage());
            }
        }
    }

    private void handleExportWithOrderByParallelMerge() {
        for (String tableName : this.command.getTableNames()) {
            try {
                ParallelMergeExportConsumer consumer;
                String filePathPrefix = FileUtil.getFilePathPrefix(this.config.getPath(), this.config.getFilenamePrefix(), tableName);
                List<TableTopology> topologyList = DbUtil.getTopology(this.dataSource.getConnection(), tableName);
                TableFieldMetaInfo tableFieldMetaInfo = DbUtil.getTableFieldMetaInfo(this.dataSource.getConnection(), this.getSchemaName(), tableName);
                List<FieldMetaInfo> orderByColumnInfoList = DbUtil.getFieldMetaInfoListByColNames(this.dataSource.getConnection(), this.getSchemaName(), tableName, this.config.getOrderByColumnNameList());
                int shardSize = topologyList.size();
                ThreadPoolExecutor executor = MyThreadPool.createExecutorWithEnsure("BatchTool", shardSize);
                LinkedList[] orderedLists = new LinkedList[shardSize];
                CountDownLatch countDownLatch = new CountDownLatch(shardSize);
                for (int i = 0; i < shardSize; ++i) {
                    orderedLists[i] = new LinkedList();
                    LocalOrderByExportProducer orderByExportProducer = new LocalOrderByExportProducer(this.dataSource, topologyList.get(i), tableFieldMetaInfo, orderedLists[i], this.config.getOrderByColumnNameList(), countDownLatch);
                    executor.submit(orderByExportProducer);
                }
                switch (this.config.getExportWay()) {
                    case MAX_LINE_NUM_IN_SINGLE_FILE: {
                        consumer = new ParallelMergeExportConsumer(filePathPrefix, this.config.getSeparator(), orderByColumnInfoList, orderedLists, this.config.getLimitNum());
                        break;
                    }
                    case FIXED_FILE_NUM: {
                        double totalRowCount = DbUtil.getTableRowCount(this.dataSource.getConnection(), tableName);
                        int fileNum = this.config.getLimitNum();
                        int singleLineLimit = (int)Math.ceil(totalRowCount / (double)fileNum);
                        consumer = new ParallelMergeExportConsumer(filePathPrefix, this.config.getSeparator(), orderByColumnInfoList, orderedLists, singleLineLimit);
                        break;
                    }
                    case DEFAULT: {
                        consumer = new ParallelMergeExportConsumer(filePathPrefix, this.config.getSeparator(), orderByColumnInfoList, orderedLists, 0);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported export exception");
                    }
                }
                try {
                    countDownLatch.await();
                    consumer.consume();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                executor.shutdown();
                logger.info("\u5bfc\u51fa {} \u6570\u636e\u5b8c\u6210", (Object)tableName);
            }
            catch (DatabaseException | SQLException e) {
                e.printStackTrace();
                logger.error(e.getMessage());
            }
        }
    }
}

