/*
 * Decompiled with CFR 0.152.
 */
package exec.export;

import cmd.BaseOperateCommand;
import com.alibaba.druid.pool.DruidDataSource;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WorkerPool;
import datasource.DataSourceConfig;
import exception.DatabaseException;
import exec.export.BaseExportExecutor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import model.CyclicAtomicInteger;
import model.config.FileFormat;
import model.db.TableFieldMetaInfo;
import model.db.TableTopology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.DbUtil;
import util.FileUtil;
import worker.MyThreadPool;
import worker.MyWorkerPool;
import worker.export.CollectFragmentWorker;
import worker.export.DirectExportWorker;
import worker.export.ExportConsumer;
import worker.export.ExportEvent;
import worker.export.ExportProducer;
import worker.factory.ExportWorkerFactory;

public class ShardingExportExecutor
extends BaseExportExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ShardingExportExecutor.class);

    public ShardingExportExecutor(DataSourceConfig dataSourceConfig, DruidDataSource druid, BaseOperateCommand baseCommand) {
        super(dataSourceConfig, druid, baseCommand);
    }

    @Override
    void exportData() {
        List<String> tableNames = this.command.getTableNames();
        if (this.command.isDbOperation()) {
            try (Connection conn = this.dataSource.getConnection();){
                tableNames = DbUtil.getAllTablesInDb(conn, this.command.getDbName());
            }
            catch (DatabaseException | SQLException e) {
                throw new RuntimeException(e);
            }
        }
        for (String tableName : tableNames) {
            this.doExportWithSharding(tableName);
        }
    }

    private void doExportWithSharding(String tableName) {
        String filePathPrefix = FileUtil.getFilePathPrefix(this.config.getPath(), this.config.getFilenamePrefix(), tableName);
        List<TableTopology> topologyList = null;
        try {
            topologyList = DbUtil.getTopology(this.dataSource.getConnection(), tableName);
        }
        catch (DatabaseException e) {
            logger.error("{}. Try export with -sharding off", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        try {
            boolean isBroadCast = DbUtil.isBroadCast(this.dataSource.getConnection(), tableName);
            if (isBroadCast) {
                TableTopology firstTopology = topologyList.get(0);
                topologyList.clear();
                topologyList.add(firstTopology);
            }
            TableFieldMetaInfo tableFieldMetaInfo = DbUtil.getTableFieldMetaInfo(this.dataSource.getConnection(), this.getSchemaName(), tableName, this.command.getColumnNames());
            int shardSize = topologyList.size();
            int parallelism = this.config.getParallelism();
            parallelism = parallelism > 0 ? parallelism : shardSize;
            Semaphore permitted = new Semaphore(parallelism, true);
            ThreadPoolExecutor executor = MyThreadPool.createExecutorWithEnsure("BatchTool", shardSize);
            CountDownLatch countDownLatch = new CountDownLatch(shardSize);
            switch (this.config.getExportWay()) {
                case MAX_LINE_NUM_IN_SINGLE_FILE: 
                case DEFAULT: {
                    for (int i = 0; i < shardSize; ++i) {
                        DirectExportWorker directExportWorker = ExportWorkerFactory.buildDefaultDirectExportWorker(this.dataSource, topologyList.get(i), tableFieldMetaInfo, filePathPrefix + i, this.config);
                        directExportWorker.setCountDownLatch(countDownLatch);
                        directExportWorker.setPermitted(permitted);
                        executor.submit(directExportWorker);
                    }
                    try {
                        countDownLatch.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case FIXED_FILE_NUM: {
                    this.shardingExportWithFixedFile(topologyList, tableFieldMetaInfo, shardSize, filePathPrefix, executor, permitted, countDownLatch);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported export exception: " + (Object)((Object)this.config.getExportWay()));
                }
            }
            executor.shutdown();
            logger.info("\u5bfc\u51fa {} \u6570\u636e\u5b8c\u6210", (Object)tableName);
        }
        catch (DatabaseException | SQLException e) {
            e.printStackTrace();
        }
    }

    private void shardingExportWithFixedFile(List<TableTopology> topologyList, TableFieldMetaInfo tableFieldMetaInfo, int shardSize, String filePathPrefix, ExecutorService executor, Semaphore permitted, CountDownLatch countDownLatch) {
        EventFactory<ExportEvent> factory = ExportEvent::new;
        RingBuffer<ExportEvent> ringBuffer = MyWorkerPool.createRingBuffer(factory);
        AtomicInteger emittedDataCounter = new AtomicInteger(0);
        int consumerCount = this.config.getLimitNum();
        int producerCount = shardSize;
        ExportConsumer[] consumers = new ExportConsumer[consumerCount];
        String[] filePaths = new String[consumerCount];
        for (int i = 0; i < consumers.length; ++i) {
            filePaths[i] = filePathPrefix + i;
            if (this.config.getFileFormat() != FileFormat.NONE) {
                int n = i;
                filePaths[n] = filePaths[n] + this.config.getFileFormat().getSuffix();
            }
            consumers[i] = new ExportConsumer(filePaths[i], emittedDataCounter, this.config.isWithHeader(), this.config.getSeparator().getBytes(), tableFieldMetaInfo, this.config.getCompressMode(), this.config.getCharset());
        }
        WorkerPool<ExportEvent> workerPool = MyWorkerPool.createWorkerPool(ringBuffer, consumers);
        workerPool.start(executor);
        ThreadPoolExecutor producerExecutor = MyThreadPool.createExecutorWithEnsure("producer", producerCount);
        if (producerCount >= consumerCount * 2) {
            for (TableTopology tableTopology : topologyList) {
                ExportProducer producer = new ExportProducer(this.dataSource, tableTopology, tableFieldMetaInfo, ringBuffer, this.config.getSeparator(), countDownLatch, emittedDataCounter, false, this.config.getQuoteEncloseMode());
                producer.setPermitted(permitted);
                producer.setWhereCondition(this.config.getWhereCondition());
                producerExecutor.submit(producer);
            }
            this.waitForFinish(countDownLatch, emittedDataCounter);
            workerPool.drainAndHalt();
        } else {
            ArrayBlockingQueue<ExportEvent> fragmentQueue = new ArrayBlockingQueue<ExportEvent>(producerCount);
            for (TableTopology topology : topologyList) {
                ExportProducer producer = new ExportProducer(this.dataSource, topology, tableFieldMetaInfo, ringBuffer, this.config.getSeparator(), countDownLatch, emittedDataCounter, true, this.config.getQuoteEncloseMode());
                producer.setWhereCondition(this.config.getWhereCondition());
                producer.setFragmentQueue(fragmentQueue);
                producer.setPermitted(permitted);
                producerExecutor.submit(producer);
            }
            CyclicAtomicInteger cyclicAtomicInteger = new CyclicAtomicInteger(consumerCount);
            this.waitForFinish(countDownLatch, emittedDataCounter);
            workerPool.drainAndHalt();
            CountDownLatch fragmentCountLatch = new CountDownLatch(consumerCount);
            for (int i = 0; i < consumerCount; ++i) {
                CollectFragmentWorker collectFragmentWorker = new CollectFragmentWorker(fragmentQueue, filePaths, cyclicAtomicInteger, fragmentCountLatch);
                executor.submit(collectFragmentWorker);
            }
            try {
                fragmentCountLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (ExportConsumer consumer : consumers) {
            consumer.close();
        }
        producerExecutor.shutdown();
    }
}

