/*
 * Decompiled with CFR 0.152.
 */
package exec.export;

import cmd.BaseOperateCommand;
import com.alibaba.druid.pool.DruidDataSource;
import datasource.DataSourceConfig;
import exception.DatabaseException;
import exec.export.BaseExportExecutor;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import model.db.TableFieldMetaInfo;
import model.db.TableTopology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.DbUtil;
import util.FileUtil;
import worker.MyThreadPool;
import worker.export.DirectExportWorker;
import worker.factory.ExportWorkerFactory;

public class SingleThreadExportExecutor
extends BaseExportExecutor {
    private static final Logger logger = LoggerFactory.getLogger(SingleThreadExportExecutor.class);

    public SingleThreadExportExecutor(DataSourceConfig dataSourceConfig, DruidDataSource druid, BaseOperateCommand baseCommand) {
        super(dataSourceConfig, druid, baseCommand);
    }

    @Override
    void exportData() {
        this.doDefaultExport();
    }

    private void doDefaultExport() {
        List<String> tableNames = this.command.getTableNames();
        ThreadPoolExecutor executor = MyThreadPool.createExecutorWithEnsure("BatchTool", tableNames.size());
        for (String tableName : tableNames) {
            String fileName = FileUtil.getFilePathPrefix(this.config.getPath(), this.config.getFilenamePrefix(), tableName) + 0;
            try {
                TableFieldMetaInfo tableFieldMetaInfo = DbUtil.getTableFieldMetaInfo(this.dataSource.getConnection(), this.getSchemaName(), tableName, this.command.getColumnNames());
                DirectExportWorker directExportWorker = ExportWorkerFactory.buildDefaultDirectExportWorker(this.dataSource, new TableTopology("", tableName), tableFieldMetaInfo, fileName, this.config);
                executor.submit(directExportWorker);
                logger.info("\u5f00\u59cb\u5bfc\u51fa\u8868 {} \u5230\u6587\u4ef6 {}", (Object)tableName, (Object)fileName);
            }
            catch (DatabaseException | SQLException e) {
                e.printStackTrace();
                logger.error(e.getMessage());
            }
        }
        executor.shutdown();
    }
}

