/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tpch;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharSource;
import io.airlift.tpch.Distribution;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;

public final class DistributionLoader {
    private DistributionLoader() {
    }

    public static <R extends Readable & Closeable> Map<String, Distribution> loadDistribution(CharSource input) throws IOException {
        try (Stream<String> lines = input.lines();){
            Map<String, Distribution> map = DistributionLoader.loadDistributions(lines.map(String::trim).filter(line -> !line.isEmpty() && !line.startsWith("#")).iterator());
            return map;
        }
    }

    private static Distribution loadDistribution(Iterator<String> lines, String name) {
        int count = -1;
        ImmutableMap.Builder<String, Integer> members = ImmutableMap.builder();
        while (lines.hasNext()) {
            int weight;
            String line = lines.next();
            if (DistributionLoader.isEnd(name, line)) {
                ImmutableMap<String, Integer> weights = members.build();
                Preconditions.checkState(count == weights.size(), "Expected %d entries in distribution %s, but only %d entries were found", count, weights.size());
                return new Distribution(name, weights);
            }
            ImmutableList<String> parts = ImmutableList.copyOf(Splitter.on('|').trimResults().omitEmptyStrings().split(line));
            Preconditions.checkState(parts.size() == 2, "Expected line to contain two parts, but it contains %d parts: %s", parts.size(), (Object)line);
            String value = (String)parts.get(0);
            try {
                weight = Integer.parseInt((String)parts.get(1));
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException(String.format("Invalid distribution %s: invalid weight on line %s", name, line));
            }
            if (value.equalsIgnoreCase("count")) {
                count = weight;
                continue;
            }
            members.put(value, weight);
        }
        throw new IllegalStateException(String.format("Invalid distribution %s: no end statement", name));
    }

    private static boolean isEnd(String name, String line) {
        ImmutableList<String> parts = ImmutableList.copyOf(Splitter.on(CharMatcher.whitespace()).omitEmptyStrings().split(line));
        if (((String)parts.get(0)).equalsIgnoreCase("END")) {
            Preconditions.checkState(parts.size() == 2 && ((String)parts.get(1)).equalsIgnoreCase(name), "Expected end statement be 'END %s', but was '%s'", (Object)name, (Object)line);
            return true;
        }
        return false;
    }

    private static Map<String, Distribution> loadDistributions(Iterator<String> lines) {
        ImmutableMap.Builder<String, Distribution> distributions = ImmutableMap.builder();
        while (lines.hasNext()) {
            String line = lines.next();
            ImmutableList<String> parts = ImmutableList.copyOf(Splitter.on(CharMatcher.whitespace()).omitEmptyStrings().split(line));
            if (parts.size() != 2 || !((String)parts.get(0)).equalsIgnoreCase("BEGIN")) continue;
            String name = (String)parts.get(1);
            Distribution distribution = DistributionLoader.loadDistribution(lines, name);
            distributions.put(name.toLowerCase(), distribution);
        }
        return distributions.build();
    }
}

