/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tpch;

import com.google.common.collect.AbstractIterator;
import io.airlift.tpch.Distribution;
import io.airlift.tpch.Distributions;
import io.airlift.tpch.RandomText;
import io.airlift.tpch.Region;
import io.airlift.tpch.TextPool;
import java.util.Iterator;
import java.util.Objects;

public class RegionGenerator
implements Iterable<Region> {
    private static final int COMMENT_AVERAGE_LENGTH = 72;
    private final Distributions distributions;
    private final TextPool textPool;

    public RegionGenerator() {
        this(Distributions.getDefaultDistributions(), TextPool.getDefaultTestPool());
    }

    public RegionGenerator(Distributions distributions, TextPool textPool) {
        this.distributions = Objects.requireNonNull(distributions, "distributions is null");
        this.textPool = Objects.requireNonNull(textPool, "textPool is null");
    }

    @Override
    public Iterator<Region> iterator() {
        return new RegionGeneratorIterator(this.distributions.getRegions(), this.textPool);
    }

    private static class RegionGeneratorIterator
    extends AbstractIterator<Region> {
        private final Distribution regions;
        private final RandomText commentRandom;
        private int index;

        private RegionGeneratorIterator(Distribution regions, TextPool textPool) {
            this.regions = regions;
            this.commentRandom = new RandomText(1500869201L, textPool, 72.0);
        }

        @Override
        protected Region computeNext() {
            if (this.index >= this.regions.size()) {
                return (Region)this.endOfData();
            }
            Region region = new Region(this.index, this.index, this.regions.getValue(this.index), this.commentRandom.nextValue());
            this.commentRandom.rowFinished();
            ++this.index;
            return region;
        }
    }
}

