/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tpch;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import io.airlift.tpch.Distribution;
import io.airlift.tpch.Distributions;
import io.airlift.tpch.RandomInt;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Supplier;

public class TextPool {
    private static final int DEFAULT_TEXT_POOL_SIZE = 314572800;
    private static final int MAX_SENTENCE_LENGTH = 256;
    private static final Supplier<TextPool> DEFAULT_TEXT_POOL = Suppliers.memoize(() -> new TextPool(314572800, Distributions.getDefaultDistributions()));
    private final byte[] textPool;
    private final int textPoolSize;

    public static TextPool getDefaultTestPool() {
        return DEFAULT_TEXT_POOL.get();
    }

    public TextPool(int size, Distributions distributions) {
        this(size, distributions, progress -> {});
    }

    public TextPool(int size, Distributions distributions, TextGenerationProgressMonitor monitor) {
        Objects.requireNonNull(distributions, "distributions is null");
        Objects.requireNonNull(monitor, "monitor is null");
        ByteArrayBuilder output = new ByteArrayBuilder(size + 256);
        RandomInt randomInt = new RandomInt(933588178L, Integer.MAX_VALUE);
        while (output.getLength() < size) {
            TextPool.generateSentence(distributions, output, randomInt);
            monitor.updateProgress(Math.min(1.0 * (double)output.getLength() / (double)size, 1.0));
        }
        output.erase(output.getLength() - size);
        this.textPool = output.getBytes();
        this.textPoolSize = output.getLength();
    }

    public int size() {
        return this.textPoolSize;
    }

    public String getText(int begin, int end) {
        if (end > this.textPoolSize) {
            throw new IndexOutOfBoundsException(String.format("Index %d is beyond end of text pool (size = %d)", end, this.textPoolSize));
        }
        return new String(this.textPool, begin, end - begin, StandardCharsets.US_ASCII);
    }

    private static void generateSentence(Distributions distributions, ByteArrayBuilder builder, RandomInt random) {
        String syntax = distributions.getGrammars().randomValue(random);
        int maxLength = syntax.length();
        for (int i = 0; i < maxLength; i += 2) {
            switch (syntax.charAt(i)) {
                case 'V': {
                    TextPool.generateVerbPhrase(distributions, builder, random);
                    break;
                }
                case 'N': {
                    TextPool.generateNounPhrase(distributions, builder, random);
                    break;
                }
                case 'P': {
                    String preposition = distributions.getPrepositions().randomValue(random);
                    builder.append(preposition);
                    builder.append(" the ");
                    TextPool.generateNounPhrase(distributions, builder, random);
                    break;
                }
                case 'T': {
                    builder.erase(1);
                    String terminator = distributions.getTerminators().randomValue(random);
                    builder.append(terminator);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown token '" + syntax.charAt(i) + "'");
                }
            }
            if (builder.getLastChar() == ' ') continue;
            builder.append(" ");
        }
    }

    private static void generateVerbPhrase(Distributions distributions, ByteArrayBuilder builder, RandomInt random) {
        String syntax = distributions.getVerbPhrase().randomValue(random);
        int maxLength = syntax.length();
        for (int i = 0; i < maxLength; i += 2) {
            Distribution source;
            switch (syntax.charAt(i)) {
                case 'D': {
                    source = distributions.getAdverbs();
                    break;
                }
                case 'V': {
                    source = distributions.getVerbs();
                    break;
                }
                case 'X': {
                    source = distributions.getAuxiliaries();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown token '" + syntax.charAt(i) + "'");
                }
            }
            String word = source.randomValue(random);
            builder.append(word);
            builder.append(" ");
        }
    }

    private static void generateNounPhrase(Distributions distributions, ByteArrayBuilder builder, RandomInt random) {
        String syntax = distributions.getNounPhrase().randomValue(random);
        int maxLength = syntax.length();
        block8: for (int i = 0; i < maxLength; ++i) {
            Distribution source;
            switch (syntax.charAt(i)) {
                case 'A': {
                    source = distributions.getArticles();
                    break;
                }
                case 'J': {
                    source = distributions.getAdjectives();
                    break;
                }
                case 'D': {
                    source = distributions.getAdverbs();
                    break;
                }
                case 'N': {
                    source = distributions.getNouns();
                    break;
                }
                case ',': {
                    builder.erase(1);
                    builder.append(", ");
                    continue block8;
                }
                case ' ': {
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Unknown token '" + syntax.charAt(i) + "'");
                }
            }
            String word = source.randomValue(random);
            builder.append(word);
            builder.append(" ");
        }
    }

    private static class ByteArrayBuilder {
        private int length;
        private final byte[] bytes;

        public ByteArrayBuilder(int size) {
            this.bytes = new byte[size];
        }

        public void append(String string) {
            string.getBytes(0, string.length(), this.bytes, this.length);
            this.length += string.length();
        }

        public void erase(int count) {
            Preconditions.checkState(this.length >= count, "not enough bytes to erase");
            this.length -= count;
        }

        public int getLength() {
            return this.length;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public char getLastChar() {
            return (char)this.bytes[this.length - 1];
        }
    }

    public static interface TextGenerationProgressMonitor {
        public void updateProgress(double var1);
    }
}

