/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import model.config.BaseConfig;
import model.db.PartitionKey;
import model.db.PrimaryKey;
import model.db.TableFieldMetaInfo;
import model.db.TableTopology;

public class ConsumerExecutionContext
extends BaseConfig {
    private DataSource dataSource;
    private List<String> tableNames;
    private AtomicInteger emittedDataCounter;
    private Map<String, List<PrimaryKey>> tablePkList;
    private Map<String, Set<Integer>> tablePkIndexSet;
    private Map<String, TableFieldMetaInfo> tableFieldMetaInfo;
    private boolean insertIgnoreAndResumeEnabled;
    private boolean funcSqlForUpdateEnabled;
    private int parallelism;
    private boolean forceParallelism;
    private String whereCondition;
    private String toUpdateColumns;
    private Map<String, List<TableTopology>> topologyList;
    private Map<String, PartitionKey> tablePartitionKey;
    private String updateWithFuncPattern;
    private boolean sqlEscapeEnabled = true;
    private boolean readProcessFileOnly = false;
    private boolean whereInEnabled = false;
    private Map<String, String> tablePkName;
    private boolean isWithLastSep;
    private boolean isParallelMerge;
    private int tpsLimit;
    private double batchTpsLimitPerConsumer;
    private List<ConcurrentHashMap<Long, AtomicInteger>> eventCounter;
    private boolean useBlock = true;
    private boolean useMagicSeparator = false;
    private String useColumns = null;
    private volatile Exception exception;

    public ConsumerExecutionContext() {
        super(false);
    }

    public List<ConcurrentHashMap<Long, AtomicInteger>> getEventCounter() {
        return this.eventCounter;
    }

    public void setEventCounter(List<ConcurrentHashMap<Long, AtomicInteger>> eventCounter) {
        this.eventCounter = eventCounter;
    }

    public AtomicInteger getEmittedDataCounter() {
        return this.emittedDataCounter;
    }

    public void setEmittedDataCounter(AtomicInteger emittedDataCounter) {
        this.emittedDataCounter = emittedDataCounter;
    }

    public Map<String, List<PrimaryKey>> getTablePkList() {
        return this.tablePkList;
    }

    public List<PrimaryKey> getTablePkList(String tableName) {
        return this.tablePkList.get(tableName);
    }

    public void setTablePkList(Map<String, List<PrimaryKey>> tablePkList) {
        this.tablePkList = tablePkList;
        this.tablePkIndexSet = new HashMap<String, Set<Integer>>(tablePkList.size() * 2);
        this.tablePkName = new HashMap<String, String>(tablePkList.size() * 2);
        for (Map.Entry<String, List<PrimaryKey>> tablePk : tablePkList.entrySet()) {
            HashSet<Integer> pkSet = new HashSet<Integer>();
            StringBuilder stringBuilder = new StringBuilder();
            for (PrimaryKey primaryKey : tablePk.getValue()) {
                pkSet.add(primaryKey.getOrdinalPosition() - 1);
                stringBuilder.append(primaryKey.getName()).append(",");
            }
            this.tablePkIndexSet.put(tablePk.getKey(), pkSet);
            this.tablePkName.put(tablePk.getKey(), stringBuilder.toString());
        }
    }

    public Map<String, TableFieldMetaInfo> getTableFieldMetaInfo() {
        return this.tableFieldMetaInfo;
    }

    public TableFieldMetaInfo getTableFieldMetaInfo(String tableName) {
        return this.tableFieldMetaInfo.get(tableName);
    }

    public void setTableFieldMetaInfo(Map<String, TableFieldMetaInfo> tableFieldMetaInfo) {
        this.tableFieldMetaInfo = tableFieldMetaInfo;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean isInsertIgnoreAndResumeEnabled() {
        return this.insertIgnoreAndResumeEnabled;
    }

    public void setInsertIgnoreAndResumeEnabled(boolean insertIgnoreAndResumeEnabled) {
        this.insertIgnoreAndResumeEnabled = insertIgnoreAndResumeEnabled;
    }

    public List<String> getTableNames() {
        return this.tableNames;
    }

    public void setTableNames(List<String> tableNames) {
        this.tableNames = tableNames;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public Map<String, Set<Integer>> getTablePkIndexSet() {
        return this.tablePkIndexSet;
    }

    public Set<Integer> getTablePkIndexSet(String tableName) {
        return this.tablePkIndexSet.get(tableName);
    }

    public String getToUpdateColumns() {
        return this.toUpdateColumns;
    }

    public void setToUpdateColumns(String toUpdateColumns) {
        this.toUpdateColumns = toUpdateColumns;
    }

    public String getWhereCondition() {
        return this.whereCondition;
    }

    public void setWhereCondition(String whereCondition) {
        this.whereCondition = whereCondition;
    }

    public Map<String, List<TableTopology>> getTopologyList() {
        return this.topologyList;
    }

    public List<TableTopology> getTopologyList(String tableName) {
        return this.topologyList.get(tableName);
    }

    public void setTopologyList(Map<String, List<TableTopology>> topologyList) {
        this.topologyList = topologyList;
    }

    public Map<String, PartitionKey> getTablePartitionKey() {
        return this.tablePartitionKey;
    }

    public PartitionKey getTablePartitionKey(String tableName) {
        return this.tablePartitionKey.get(tableName);
    }

    public void setTablePartitionKey(Map<String, PartitionKey> tablePartitionKey) {
        this.tablePartitionKey = tablePartitionKey;
    }

    public int getTpsLimit() {
        return this.tpsLimit;
    }

    public void setTpsLimit(int tpsLimit) {
        this.tpsLimit = tpsLimit;
    }

    public double getBatchTpsLimitPerConsumer() {
        return this.batchTpsLimitPerConsumer;
    }

    public void setBatchTpsLimitPerConsumer(double batchTpsLimitPerConsumer) {
        this.batchTpsLimitPerConsumer = batchTpsLimitPerConsumer;
    }

    @Override
    public String toString() {
        return "ConsumerExecutionContext{tableNames=" + this.tableNames + ", partitionKey=" + this.tablePartitionKey + ", pkList=" + this.tablePkList + ", insertIgnoreAndResumeEnabled=" + this.insertIgnoreAndResumeEnabled + ", parallelism=" + this.parallelism + ", whereCondition='" + this.whereCondition + '\'' + ", toUpdateColumns='" + this.toUpdateColumns + '\'' + ", updateWithFuncPattern='" + this.updateWithFuncPattern + '\'' + ", sqlEscapeEnabled=" + this.sqlEscapeEnabled + '}';
    }

    public String getUpdateWithFuncPattern() {
        return this.updateWithFuncPattern;
    }

    public void setUpdateWithFuncPattern(String updateWithFuncPattern) {
        this.updateWithFuncPattern = updateWithFuncPattern;
    }

    public boolean isFuncSqlForUpdateEnabled() {
        return this.funcSqlForUpdateEnabled;
    }

    public void setFuncSqlForUpdateEnabled(boolean funcSqlForUpdateEnabled) {
        this.funcSqlForUpdateEnabled = funcSqlForUpdateEnabled;
    }

    public boolean isSqlEscapeEnabled() {
        return this.sqlEscapeEnabled;
    }

    public void setSqlEscapeEnabled(boolean sqlEscapeEnabled) {
        this.sqlEscapeEnabled = sqlEscapeEnabled;
    }

    public boolean isReadProcessFileOnly() {
        return this.readProcessFileOnly;
    }

    public void setReadProcessFileOnly(boolean readProcessFileOnly) {
        this.readProcessFileOnly = readProcessFileOnly;
    }

    public boolean isWhereInEnabled() {
        return this.whereInEnabled;
    }

    public void setWhereInEnabled(boolean whereInEnabled) {
        this.whereInEnabled = whereInEnabled;
    }

    public Map<String, String> getTablePkName() {
        return this.tablePkName;
    }

    public String getTablePkName(String tableName) {
        return this.tablePkName.get(tableName);
    }

    public boolean isWithLastSep() {
        return this.isWithLastSep;
    }

    public void setWithLastSep(boolean withLastSep) {
        this.isWithLastSep = withLastSep;
    }

    public boolean isParallelMerge() {
        return this.isParallelMerge;
    }

    public void setParallelMerge(boolean parallelMerge) {
        this.isParallelMerge = parallelMerge;
    }

    public boolean isForceParallelism() {
        return this.forceParallelism;
    }

    public void setForceParallelism(boolean forceParallelism) {
        this.forceParallelism = forceParallelism;
    }

    public boolean isUseBlock() {
        return this.useBlock;
    }

    public void setUseBlock(boolean useBlock) {
        this.useBlock = useBlock;
    }

    public boolean isUseMagicSeparator() {
        return this.useMagicSeparator;
    }

    public void setUseMagicSeparator(boolean useMagicSeparator) {
        this.useMagicSeparator = useMagicSeparator;
    }

    public boolean isSingleThread() {
        return this.parallelism == 1;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public String getUseColumns() {
        return this.useColumns;
    }

    public void setUseColumns(String useColumns) {
        this.useColumns = useColumns;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.tableNames != null && this.tableNames.size() > 1 && this.useColumns != null) {
            throw new UnsupportedOperationException("Do not support multi-table operation with specified columns");
        }
    }
}

