/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public class CyclicAtomicInteger {
    private static final long PARK_TIME = 1000000L;
    private AtomicInteger counter;
    private int range;

    public CyclicAtomicInteger(int range) {
        this.counter = new AtomicInteger(0);
        this.range = range;
    }

    public CyclicAtomicInteger(int initialValue, int range) {
        this.counter = new AtomicInteger(initialValue);
        this.range = range;
    }

    public int next() {
        int next;
        int c;
        while (!this.counter.compareAndSet(c = this.counter.get(), next = (c + 1) % this.range)) {
            LockSupport.parkNanos(1000000L);
        }
        return c;
    }
}

