/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import model.config.BaseConfig;
import model.config.BenchmarkMode;
import model.config.FileLineRecord;
import model.config.QuoteEncloseMode;
import org.apache.commons.lang.StringUtils;

public class ProducerExecutionContext
extends BaseConfig {
    private ThreadPoolExecutor producerExecutor;
    private List<FileLineRecord> fileRecordList;
    private int parallelism;
    private int readBlockSizeInMb = 2;
    private List<ConcurrentHashMap<Long, AtomicInteger>> eventCounter;
    private int nextFileIndex = 0;
    private long nextBlockIndex = 0L;
    private String contextString;
    private String historyFile;
    private int maxErrorCount;
    private AtomicInteger emittedDataCounter;
    private CountDownLatch countDownLatch;
    private volatile Exception exception;
    protected BenchmarkMode benchmarkMode;
    protected int scale;

    public ProducerExecutionContext() {
        super(false);
    }

    public ThreadPoolExecutor getProducerExecutor() {
        return this.producerExecutor;
    }

    public void setProducerExecutor(ThreadPoolExecutor producerExecutor) {
        this.producerExecutor = producerExecutor;
    }

    public List<FileLineRecord> getFileLineRecordList() {
        return this.fileRecordList;
    }

    public void setFileLineRecordList(List<FileLineRecord> fileRecordList) {
        this.fileRecordList = fileRecordList;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public int getReadBlockSizeInMb() {
        return this.readBlockSizeInMb;
    }

    public void setReadBlockSizeInMb(int readBlockSizeInMb) {
        this.readBlockSizeInMb = readBlockSizeInMb;
    }

    public List<ConcurrentHashMap<Long, AtomicInteger>> getEventCounter() {
        return this.eventCounter;
    }

    public void setEventCounter(List<ConcurrentHashMap<Long, AtomicInteger>> eventCounter) {
        this.eventCounter = eventCounter;
    }

    public AtomicInteger getEmittedDataCounter() {
        return this.emittedDataCounter;
    }

    public void setEmittedDataCounter(AtomicInteger emittedDataCounter) {
        this.emittedDataCounter = emittedDataCounter;
    }

    public int getNextFileIndex() {
        return this.nextFileIndex;
    }

    public void setNextFileIndex(int nextFileIndex) {
        this.nextFileIndex = nextFileIndex;
    }

    public long getNextBlockIndex() {
        return this.nextBlockIndex;
    }

    public void setNextBlockIndex(long nextBlockIndex) {
        this.nextBlockIndex = nextBlockIndex;
    }

    public String getContextString() {
        return this.contextString;
    }

    public void setContextString(String contextString) {
        this.contextString = contextString;
    }

    public void checkAndSetContextString(String newContextString) {
        if (!StringUtils.equals(this.contextString, newContextString)) {
            this.setContextString(newContextString);
            this.setNextFileIndex(0);
            this.setNextBlockIndex(0L);
        }
    }

    public String getHistoryFile() {
        return this.historyFile;
    }

    public void setHistoryFile(String historyFile) {
        this.historyFile = historyFile;
    }

    public void setHistoryFileAndParse(String historyFile) {
        if (historyFile == null) {
            return;
        }
        this.setHistoryFile(historyFile);
        File file = new File(historyFile);
        Scanner fromFile = null;
        try {
            if (file.exists()) {
                fromFile = new Scanner(file);
                this.setContextString(fromFile.nextLine());
                this.setNextFileIndex(fromFile.nextInt());
                this.setNextBlockIndex(fromFile.nextLong());
            }
        }
        catch (IOException e) {
            fromFile.close();
            e.printStackTrace();
        }
    }

    public void saveToHistoryFile(boolean isFinished) {
        if (this.historyFile == null) {
            return;
        }
        try {
            File file = new File(this.historyFile);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fileWriter = new FileWriter(this.historyFile, false);
            BufferedWriter out = new BufferedWriter(fileWriter);
            if (isFinished) {
                this.nextFileIndex = this.fileRecordList.size();
                this.nextBlockIndex = 0L;
            }
            out.write(this.contextString);
            out.newLine();
            out.write(Integer.toString(this.nextFileIndex));
            out.newLine();
            out.write(Long.toString(this.nextBlockIndex));
            out.newLine();
            out.flush();
            out.close();
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CountDownLatch getCountDownLatch() {
        return this.countDownLatch;
    }

    public void setCountDownLatch(CountDownLatch countDownLatch) {
        this.countDownLatch = countDownLatch;
    }

    public boolean isSingleThread() {
        return this.parallelism == 1;
    }

    public int getMaxErrorCount() {
        return this.maxErrorCount;
    }

    public void setMaxErrorCount(int maxErrorCount) {
        this.maxErrorCount = maxErrorCount;
    }

    public boolean isUtfCharset() {
        return this.charset.equals(StandardCharsets.UTF_8) || this.charset.equals(StandardCharsets.UTF_16);
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public BenchmarkMode getBenchmarkMode() {
        return this.benchmarkMode;
    }

    public void setBenchmarkMode(BenchmarkMode benchmarkMode) {
        this.benchmarkMode = benchmarkMode;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    @Override
    public String toString() {
        return "ProducerExecutionContext{filePathList=" + this.fileRecordList + ", parallelism=" + this.parallelism + ", readBlockSizeInMb=" + this.readBlockSizeInMb + ", " + super.toString() + '}';
    }

    @Override
    public void validate() {
        super.validate();
        if (this.quoteEncloseMode == QuoteEncloseMode.FORCE) {
            this.parallelism = this.fileRecordList.size();
        }
    }
}

