/*
 * Decompiled with CFR 0.152.
 */
package model.config;

import java.nio.charset.Charset;
import model.config.CompressMode;
import model.config.ConfigConstant;
import model.config.DdlMode;
import model.config.EncryptionConfig;
import model.config.FileFormat;
import model.config.QuoteEncloseMode;

public class BaseConfig {
    protected String separator = ",";
    protected Charset charset = ConfigConstant.DEFAULT_CHARSET;
    protected boolean isWithHeader = false;
    protected boolean shardingEnabled;
    protected DdlMode ddlMode = DdlMode.NO_DDL;
    protected CompressMode compressMode = CompressMode.NONE;
    protected EncryptionConfig encryptionConfig = EncryptionConfig.NONE;
    protected FileFormat fileFormat = FileFormat.NONE;
    protected QuoteEncloseMode quoteEncloseMode;
    private FileMode fileMode = new FileMode();

    public BaseConfig(boolean shardingEnabled) {
        this.shardingEnabled = shardingEnabled;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        for (String illegalStr : ConfigConstant.ILLEGAL_SEPARATORS) {
            if (!separator.contains(illegalStr)) continue;
            throw new IllegalArgumentException("Illegal separator: " + separator);
        }
        this.separator = separator;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public boolean isWithHeader() {
        return this.isWithHeader;
    }

    public void setWithHeader(boolean withHeader) {
        this.isWithHeader = withHeader;
    }

    public boolean isShardingEnabled() {
        return this.shardingEnabled;
    }

    public QuoteEncloseMode getQuoteEncloseMode() {
        return this.quoteEncloseMode;
    }

    public void setQuoteEncloseMode(QuoteEncloseMode quoteEncloseMode) {
        this.quoteEncloseMode = quoteEncloseMode;
    }

    public DdlMode getDdlMode() {
        return this.ddlMode;
    }

    public void setDdlMode(DdlMode ddlMode) {
        this.ddlMode = ddlMode;
    }

    public CompressMode getCompressMode() {
        return this.compressMode;
    }

    public void setCompressMode(CompressMode compressMode) {
        this.compressMode = compressMode;
        if (compressMode != CompressMode.NONE) {
            this.fileMode.setCompress();
        }
    }

    public EncryptionConfig getEncryptionConfig() {
        return this.encryptionConfig;
    }

    public void setEncryptionConfig(EncryptionConfig encryptionConfig) {
        this.encryptionConfig = encryptionConfig;
        if (!encryptionConfig.equals(EncryptionConfig.NONE)) {
            this.fileMode.setEncryption();
        }
    }

    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
        if (fileFormat != FileFormat.NONE) {
            this.fileMode.setFileFormat();
        }
    }

    public void validate() {
        if (this.fileMode.bitCount() > 1) {
            throw new IllegalArgumentException(String.format("Please check compression/encryption/file-format config: %s/%s/%s", new Object[]{this.compressMode, this.encryptionConfig, this.fileFormat}));
        }
    }

    public String toString() {
        return "BaseConfig{separator='" + this.separator + '\'' + ", charset='" + this.charset + '\'' + ", isWithHeader='" + this.isWithHeader + '\'' + ", compressMode='" + (Object)((Object)this.compressMode) + '\'' + ", encryptionConfig='" + this.encryptionConfig + '\'' + '}';
    }

    private static class FileMode {
        static final byte COMPRESS_FLAG = 1;
        static final byte ENCRYPTION_FLAG = 4;
        static final byte FILE_FORMAT_FLAG = 8;
        byte flag = 0;

        private FileMode() {
        }

        void setCompress() {
            this.flag = (byte)(this.flag | 1);
        }

        void setEncryption() {
            this.flag = (byte)(this.flag | 4);
        }

        void setFileFormat() {
            this.flag = (byte)(this.flag | 8);
        }

        int bitCount() {
            int count = 0;
            byte n = this.flag;
            while (n != 0) {
                n = (byte)(n & n - 1);
                ++count;
            }
            return count;
        }
    }
}

