/*
 * Decompiled with CFR 0.152.
 */
package model.config;

import java.util.Arrays;
import java.util.Objects;
import model.config.EncryptionMode;

public class EncryptionConfig {
    public static final EncryptionConfig NONE = new EncryptionConfig(EncryptionMode.NONE, "");
    private final EncryptionMode encryptionMode;
    private final String key;
    private final byte[] initVector;

    public EncryptionConfig(EncryptionMode encryptionMode, String key) {
        this.encryptionMode = encryptionMode;
        this.key = key;
        this.initVector = null;
    }

    public static EncryptionConfig parse(String encryptionModeStr, String key) {
        EncryptionMode encryptionMode = EncryptionMode.fromString(encryptionModeStr);
        if (encryptionMode == EncryptionMode.NONE) {
            return NONE;
        }
        return new EncryptionConfig(encryptionMode, key);
    }

    public EncryptionMode getEncryptionMode() {
        return this.encryptionMode;
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        if (this.encryptionMode == EncryptionMode.NONE) {
            return "Non-encrypted";
        }
        return "{encryptionMode=" + (Object)((Object)this.encryptionMode) + ", key='" + this.key + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptionConfig that = (EncryptionConfig)o;
        if (this.encryptionMode == EncryptionMode.NONE && this.encryptionMode == that.encryptionMode) {
            return true;
        }
        return this.encryptionMode == that.encryptionMode && this.key.equals(that.key) && Arrays.equals(this.initVector, that.initVector);
    }

    public int hashCode() {
        if (this.encryptionMode == EncryptionMode.NONE) {
            return this.encryptionMode.hashCode();
        }
        int result = Objects.hash(new Object[]{this.encryptionMode, this.key});
        result = 31 * result + Arrays.hashCode(this.initVector);
        return result;
    }
}

