/*
 * Decompiled with CFR 0.152.
 */
package model.config;

public enum EncryptionMode {
    NONE(true),
    CAESAR(true),
    AES_CBC(false),
    SM4_ECB(false);

    private final boolean supportStreamingBit;

    private EncryptionMode(boolean supportStreamingBit) {
        this.supportStreamingBit = supportStreamingBit;
    }

    static EncryptionMode fromString(String encryptionMode) {
        switch (encryptionMode.toUpperCase()) {
            case "NONE": {
                return NONE;
            }
            case "DEFAULT": 
            case "CAESAR": {
                return CAESAR;
            }
            case "AES": 
            case "AES-CBC": {
                return AES_CBC;
            }
            case "SM4": 
            case "SM4-ECB": {
                return SM4_ECB;
            }
        }
        throw new IllegalArgumentException("Unrecognized encryption mode: " + encryptionMode);
    }

    public boolean isSupportStreamingBit() {
        return this.supportStreamingBit;
    }
}

