/*
 * Decompiled with CFR 0.152.
 */
package model.config;

import java.util.List;
import model.config.BaseConfig;
import model.config.ConfigConstant;
import model.config.GlobalVar;
import model.config.QuoteEncloseMode;

public class ExportConfig
extends BaseConfig {
    private String path;
    private String filenamePrefix;
    private ExportWay exportWay;
    private int limitNum;
    private String whereCondition;
    private List<String> orderByColumnNameList;
    private int parallelism = 0;
    private boolean isAscending = true;
    private boolean isLocalMerge = false;
    private boolean isParallelMerge = false;

    public ExportConfig() {
        this("", ",", ExportWay.DEFAULT, 0, "", ConfigConstant.DEFAULT_QUOTE_ENCLOSE_MODE);
    }

    public ExportConfig(String filenamePrefix, String separator, ExportWay exportWay, int limitNum, String whereCondition, QuoteEncloseMode quoteEncloseMode) {
        super(true);
        this.separator = separator;
        this.filenamePrefix = filenamePrefix;
        this.exportWay = exportWay;
        this.limitNum = limitNum;
        this.whereCondition = whereCondition;
        this.quoteEncloseMode = quoteEncloseMode;
    }

    public void setFixedFileNum(int num) {
        this.exportWay = ExportWay.FIXED_FILE_NUM;
        this.limitNum = num;
    }

    public void setMaxLine(int num) {
        if (num < GlobalVar.EMIT_BATCH_SIZE) {
            throw new IllegalArgumentException("Max line should be greater than " + GlobalVar.EMIT_BATCH_SIZE);
        }
        this.exportWay = ExportWay.MAX_LINE_NUM_IN_SINGLE_FILE;
        this.limitNum = num;
    }

    public String getFilenamePrefix() {
        return this.filenamePrefix;
    }

    public void setFilenamePrefix(String filenamePrefix) {
        this.filenamePrefix = filenamePrefix;
    }

    public ExportWay getExportWay() {
        return this.exportWay;
    }

    public void setExportWay(ExportWay exportWay) {
        this.exportWay = exportWay;
    }

    public String getWhereCondition() {
        return this.whereCondition;
    }

    public void setWhereCondition(String whereCondition) {
        this.whereCondition = whereCondition;
    }

    public int getLimitNum() {
        return this.limitNum;
    }

    public void setLimitNum(int limitNum) {
        this.limitNum = limitNum;
    }

    public List<String> getOrderByColumnNameList() {
        return this.orderByColumnNameList;
    }

    public void setOrderByColumnNameList(List<String> orderByColumnNameList) {
        this.orderByColumnNameList = orderByColumnNameList;
    }

    public String getPath() {
        if (this.path == null) {
            return "";
        }
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isAscending() {
        return this.isAscending;
    }

    public void setAscending(boolean ascending) {
        this.isAscending = ascending;
    }

    public boolean isLocalMerge() {
        return this.isLocalMerge;
    }

    public void setLocalMerge(boolean localMerge) {
        this.isLocalMerge = localMerge;
    }

    public boolean isParallelMerge() {
        return this.isParallelMerge;
    }

    public void setParallelMerge(boolean parallelMerge) {
        this.isParallelMerge = parallelMerge;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    private String getParallelismConfig() {
        if (this.parallelism > 0) {
            return String.valueOf(this.parallelism);
        }
        return "DEFAULT";
    }

    @Override
    public void validate() {
        super.validate();
        if (this.exportWay != ExportWay.DEFAULT && !this.fileFormat.isSupportBlock()) {
            throw new UnsupportedOperationException(String.format("Export with format [%s] by [%s] is not supported yet", new Object[]{this.fileFormat, this.exportWay}));
        }
    }

    @Override
    public String toString() {
        return "ExportConfig{path='" + this.path + '\'' + ", filenamePrefix='" + this.filenamePrefix + '\'' + ", exportWay=" + (Object)((Object)this.exportWay) + ", isWithHeader=" + this.isWithHeader() + ", limitNum=" + this.limitNum + ", whereCondition='" + this.whereCondition + '\'' + ", orderByColumnNameList=" + this.orderByColumnNameList + ", isAscending=" + this.isAscending + ", isLocalMerge=" + this.isLocalMerge + ", isParallelMerge=" + this.isParallelMerge + ", parallelism=" + this.getParallelismConfig() + "} " + super.toString();
    }

    public static enum ExportWay {
        MAX_LINE_NUM_IN_SINGLE_FILE,
        FIXED_FILE_NUM,
        DEFAULT;

    }
}

