/*
 * Decompiled with CFR 0.152.
 */
package model.config;

import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class FileBlockListRecord {
    private final List<File> fileList;
    private final AtomicInteger currentFileIndex;
    private final AtomicBoolean[] fileDoneList;
    private final AtomicLong[] startPosArr;

    public FileBlockListRecord(List<File> fileList, int nextFileIndex, long nextBlockIndex) {
        this.fileList = fileList;
        this.currentFileIndex = new AtomicInteger(nextFileIndex);
        this.fileDoneList = new AtomicBoolean[fileList.size()];
        this.startPosArr = new AtomicLong[fileList.size()];
        for (int i = 0; i < this.startPosArr.length; ++i) {
            if (i < nextFileIndex) {
                this.fileDoneList[i] = new AtomicBoolean(true);
                this.startPosArr[i] = new AtomicLong(0L);
                continue;
            }
            if (i == nextFileIndex) {
                this.fileDoneList[i] = new AtomicBoolean(false);
                this.startPosArr[i] = new AtomicLong(nextBlockIndex);
                continue;
            }
            this.fileDoneList[i] = new AtomicBoolean(false);
            this.startPosArr[i] = new AtomicLong(0L);
        }
    }

    public AtomicInteger getCurrentFileIndex() {
        return this.currentFileIndex;
    }

    public AtomicBoolean[] getFileDoneList() {
        return this.fileDoneList;
    }

    public AtomicLong[] getStartPosArr() {
        return this.startPosArr;
    }

    public List<File> getFileList() {
        return this.fileList;
    }
}

