/*
 * Decompiled with CFR 0.152.
 */
package model.config;

public enum FileFormat {
    NONE("", true),
    TXT(".txt", true),
    CSV(".csv", true),
    LOG(".log", true),
    XLSX(".xlsx", false),
    ET(".et", false),
    XLS(".xls", false);

    private final String suffix;
    private final boolean supportBlock;

    private FileFormat(String suffix, boolean supportBlock) {
        this.suffix = suffix;
        this.supportBlock = supportBlock;
    }

    public static FileFormat fromString(String compressMode) {
        switch (compressMode.toUpperCase()) {
            case "NONE": {
                return NONE;
            }
            case "TXT": {
                return TXT;
            }
            case "CSV": {
                return CSV;
            }
            case "LOG": {
                return LOG;
            }
            case "XLSX": {
                return XLSX;
            }
            case "ET": {
                return ET;
            }
            case "XLS": {
                return XLS;
            }
        }
        throw new IllegalArgumentException("Unrecognized file format: " + compressMode);
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean isSupportBlock() {
        return this.supportBlock;
    }
}

