/*
 * Decompiled with CFR 0.152.
 */
package model.db;

import com.google.common.collect.ImmutableSet;

public class FieldMetaInfo {
    private String name;
    private Type type;
    private int index;
    public static final ImmutableSet<String> STRING_TYPE_SET = ImmutableSet.of("varchar", "char", "text", "tinytext", "mediumtext", "longtext", new String[]{"enum"});
    public static final ImmutableSet<String> NUMBER_INT_TYPE_SET = ImmutableSet.of("tinyint", "smallint", "integer", "int", "mediumint", "bigint", new String[0]);
    public static final ImmutableSet<String> NUMBER_FLOAT_TYPE_SET = ImmutableSet.of("decimal", "float", "double");
    public static final ImmutableSet<String> DATE_TYPE_SET = ImmutableSet.of("date", "year", "time", "datetime", "timestamp");

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Type getType() {
        return this.type;
    }

    public boolean needQuote() {
        switch (this.type) {
            case STRING: 
            case DATE: 
            case DATETIME: 
            case OTHER: {
                return true;
            }
            case INT: 
            case FLOAT: {
                return false;
            }
        }
        return true;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setType(String typeStr) {
        this.type = STRING_TYPE_SET.contains(typeStr = typeStr.toLowerCase()) ? Type.STRING : (NUMBER_INT_TYPE_SET.contains(typeStr) ? Type.INT : (NUMBER_FLOAT_TYPE_SET.contains(typeStr) ? Type.FLOAT : (DATE_TYPE_SET.contains(typeStr) ? Type.DATE : Type.OTHER)));
    }

    public String toString() {
        return "FieldMetaInfo{name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + ", index=" + this.index + '}';
    }

    public static enum Type {
        STRING,
        INT,
        FLOAT,
        DATE,
        DATETIME,
        OTHER;

    }
}

