/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.alibaba.druid.util.JdbcUtils;
import exception.DatabaseException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import model.db.FieldMetaInfo;
import model.db.PartitionKey;
import model.db.PrimaryKey;
import model.db.TableFieldMetaInfo;
import model.db.TableTopology;
import org.apache.commons.lang.StringUtils;

public class DbUtil {
    private static final String PK_INDEX_SQL_PATTERN = "SELECT ORDINAL_POSITION,COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA='%s' and TABLE_NAME='%s' and COLUMN_KEY='PRI';";
    private static final String PK_INFO_SQL_PATTERN = "SELECT COLUMN_NAME,DATA_TYPE,ORDINAL_POSITION from INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA='%s' and TABLE_NAME='%s' and COLUMN_KEY='PRI';";
    private static final String FIELD_INFO_SQL_PATTERN = "SELECT COLUMN_NAME,DATA_TYPE,ORDINAL_POSITION from INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA='%s' and TABLE_NAME='%s'\nORDER BY ORDINAL_POSITION;";
    private static final String DB_FIELD_INFO_SQL_PATTERN = "SELECT COLUMN_NAME,DATA_TYPE,ORDINAL_POSITION,TABLE_NAME from INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA='%s'\nORDER BY TABLE_NAME,ORDINAL_POSITION;";
    private static final String SINGLE_FIELD_INFO_SQL_PATTERN = "SELECT DATA_TYPE,ORDINAL_POSITION from INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA='%s' and TABLE_NAME='%s' and COLUMN_NAME='%s';";
    private static final String MULTI_FIELD_INFO_SQL_PATTERN = "SELECT COLUMN_NAME,DATA_TYPE,ORDINAL_POSITION from INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA='%s' and TABLE_NAME='%s' and COLUMN_NAME in (%s);";
    private static final String PARTITION_KEY_SQL_PATTERN = "SHOW RULE FROM `%s`;";
    private static final String ROW_COUNT_SQL_PATTERN = "SELECT COUNT(*) FROM `%s`;";
    private static final String PARTITION_KEY_INFO_SQL_PATTERN = "SELECT DATA_TYPE,ORDINAL_POSITION from INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA='%s' and TABLE_NAME='%s' and COLUMN_NAME = '%s'";

    public static List<TableTopology> getTopology(Connection conn, String tableName) throws DatabaseException {
        ArrayList<TableTopology> arrayList;
        Statement stmt = null;
        ResultSet resultSet = null;
        String sql = String.format("SHOW TOPOLOGY FROM `%s`", tableName);
        ArrayList<TableTopology> topologyList = new ArrayList<TableTopology>();
        try {
            stmt = conn.createStatement();
            resultSet = stmt.executeQuery(sql);
            while (resultSet.next()) {
                topologyList.add(new TableTopology(resultSet.getString("GROUP_NAME"), resultSet.getString("TABLE_NAME")));
            }
            arrayList = topologyList;
        }
        catch (SQLException e) {
            try {
                throw new DatabaseException("Unable to get topology of table " + tableName, e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                JdbcUtils.close(stmt);
                JdbcUtils.close(conn);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet);
        JdbcUtils.close(stmt);
        JdbcUtils.close(conn);
        return arrayList;
    }

    public static List<PrimaryKey> getPkList(Connection conn, String schemaName, String tableName) throws DatabaseException {
        ArrayList<PrimaryKey> arrayList;
        Statement stmt = null;
        ResultSet resultSet = null;
        String sql = String.format(PK_INDEX_SQL_PATTERN, schemaName, tableName);
        ArrayList<PrimaryKey> pkList = new ArrayList<PrimaryKey>();
        try {
            stmt = conn.createStatement();
            resultSet = stmt.executeQuery(sql);
            while (resultSet.next()) {
                int ordinalPos = resultSet.getInt(1);
                String name = resultSet.getString(2);
                pkList.add(new PrimaryKey(ordinalPos, name));
            }
            if (pkList.isEmpty()) {
                throw new DatabaseException("Unable to get primary key of table " + tableName);
            }
            arrayList = pkList;
        }
        catch (SQLException e) {
            try {
                throw new DatabaseException("Unable to get primary key of table " + tableName, e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                JdbcUtils.close(stmt);
                JdbcUtils.close(conn);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet);
        JdbcUtils.close(stmt);
        JdbcUtils.close(conn);
        return arrayList;
    }

    public static TableFieldMetaInfo getTableFieldMetaInfoForUpdate(Connection conn, String schemaName, String tableName) throws DatabaseException {
        TableFieldMetaInfo tableFieldMetaInfo;
        Statement stmt = null;
        ResultSet resultSet = null;
        String pkIndexSql = String.format(PK_INDEX_SQL_PATTERN, schemaName, tableName);
        String metaInfoSql = String.format(FIELD_INFO_SQL_PATTERN, schemaName, tableName);
        TableFieldMetaInfo tableFieldMetaInfo2 = new TableFieldMetaInfo();
        try {
            stmt = conn.createStatement();
            resultSet = stmt.executeQuery(pkIndexSql);
            if (!resultSet.next()) {
                throw new DatabaseException("Unable to get primary key of table " + tableName);
            }
            int index = resultSet.getInt(1);
            String name = resultSet.getString(2);
            tableFieldMetaInfo2.setPrimaryKey(new PrimaryKey(index, name));
            ArrayList<FieldMetaInfo> fieldMetaInfoList = new ArrayList<FieldMetaInfo>();
            stmt = conn.createStatement();
            resultSet = stmt.executeQuery(metaInfoSql);
            while (resultSet.next()) {
                FieldMetaInfo fieldMetaInfo = new FieldMetaInfo();
                fieldMetaInfo.setType(resultSet.getString(2));
                if (fieldMetaInfo.getType() == FieldMetaInfo.Type.OTHER) continue;
                fieldMetaInfo.setName(resultSet.getString(1));
                fieldMetaInfo.setIndex(resultSet.getInt(3) - 1);
                fieldMetaInfoList.add(fieldMetaInfo);
            }
            tableFieldMetaInfo2.setFieldMetaInfoList(fieldMetaInfoList);
            tableFieldMetaInfo = tableFieldMetaInfo2;
        }
        catch (SQLException e) {
            try {
                throw new DatabaseException("Unable to get meta info of columns in " + tableName, e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                JdbcUtils.close(stmt);
                JdbcUtils.close(conn);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet);
        JdbcUtils.close(stmt);
        JdbcUtils.close(conn);
        return tableFieldMetaInfo;
    }

    public static TableFieldMetaInfo getTableFieldMetaInfoForReplace(Connection conn, String schemaName, String tableName) throws DatabaseException {
        TableFieldMetaInfo tableFieldMetaInfo;
        Statement stmt = null;
        ResultSet resultSet = null;
        String pkIndexSql = String.format(PK_INDEX_SQL_PATTERN, schemaName, tableName);
        String metaInfoSql = String.format(FIELD_INFO_SQL_PATTERN, schemaName, tableName);
        TableFieldMetaInfo tableFieldMetaInfo2 = new TableFieldMetaInfo();
        try {
            stmt = conn.createStatement();
            resultSet = stmt.executeQuery(pkIndexSql);
            if (!resultSet.next()) {
                throw new DatabaseException("Unable to get primary key of table " + tableName);
            }
            int index = resultSet.getInt(1);
            String name = resultSet.getString(2);
            tableFieldMetaInfo2.setPrimaryKey(new PrimaryKey(index, name));
            ArrayList<FieldMetaInfo> fieldMetaInfoList = new ArrayList<FieldMetaInfo>();
            stmt = conn.createStatement();
            resultSet = stmt.executeQuery(metaInfoSql);
            while (resultSet.next()) {
                FieldMetaInfo fieldMetaInfo = new FieldMetaInfo();
                fieldMetaInfo.setType(resultSet.getString(2));
                fieldMetaInfo.setName(resultSet.getString(1));
                fieldMetaInfo.setIndex(resultSet.getInt(3) - 1);
                fieldMetaInfoList.add(fieldMetaInfo);
            }
            tableFieldMetaInfo2.setFieldMetaInfoList(fieldMetaInfoList);
            tableFieldMetaInfo = tableFieldMetaInfo2;
        }
        catch (SQLException e) {
            try {
                throw new DatabaseException("Unable to get meta info of columns in " + tableName, e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                JdbcUtils.close(stmt);
                JdbcUtils.close(conn);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet);
        JdbcUtils.close(stmt);
        JdbcUtils.close(conn);
        return tableFieldMetaInfo;
    }

    public static TableFieldMetaInfo getTableFieldMetaInfo(Connection conn, String schemaName, String tableName) throws DatabaseException {
        TableFieldMetaInfo tableFieldMetaInfo;
        Statement stmt = null;
        ResultSet resultSet = null;
        String metaInfoSql = String.format(FIELD_INFO_SQL_PATTERN, schemaName, tableName);
        TableFieldMetaInfo tableFieldMetaInfo2 = new TableFieldMetaInfo();
        try {
            ArrayList<FieldMetaInfo> fieldMetaInfoList = new ArrayList<FieldMetaInfo>();
            stmt = conn.createStatement();
            resultSet = stmt.executeQuery(metaInfoSql);
            while (resultSet.next()) {
                FieldMetaInfo fieldMetaInfo = new FieldMetaInfo();
                fieldMetaInfo.setName(resultSet.getString(1));
                fieldMetaInfo.setType(resultSet.getString(2));
                fieldMetaInfo.setIndex(resultSet.getInt(3) - 1);
                fieldMetaInfoList.add(fieldMetaInfo);
            }
            tableFieldMetaInfo2.setFieldMetaInfoList(fieldMetaInfoList);
            tableFieldMetaInfo = tableFieldMetaInfo2;
        }
        catch (SQLException e) {
            try {
                throw new DatabaseException("Unable to get meta info of columns in " + tableName, e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                JdbcUtils.close(stmt);
                JdbcUtils.close(conn);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet);
        JdbcUtils.close(stmt);
        JdbcUtils.close(conn);
        return tableFieldMetaInfo;
    }

    public static Map<String, TableFieldMetaInfo> getDbFieldMetaInfo(Connection conn, String schemaName, List<String> tableNames) throws DatabaseException {
        Object tableName;
        HashMap<String, TableFieldMetaInfo> resultMap = new HashMap<String, TableFieldMetaInfo>();
        for (String tableName2 : tableNames) {
            TableFieldMetaInfo metaInfo = new TableFieldMetaInfo();
            metaInfo.setFieldMetaInfoList(new ArrayList<FieldMetaInfo>());
            resultMap.put(tableName2, metaInfo);
        }
        Statement stmt = null;
        ResultSet resultSet = null;
        String metaInfoSql = String.format(DB_FIELD_INFO_SQL_PATTERN, schemaName);
        try {
            stmt = conn.createStatement();
            resultSet = stmt.executeQuery(metaInfoSql);
            while (resultSet.next()) {
                tableName = resultSet.getString(4);
                TableFieldMetaInfo metaInfo = (TableFieldMetaInfo)resultMap.get(tableName);
                if (metaInfo == null) continue;
                FieldMetaInfo fieldMetaInfo = new FieldMetaInfo();
                fieldMetaInfo.setName(resultSet.getString(1));
                fieldMetaInfo.setType(resultSet.getString(2));
                fieldMetaInfo.setIndex(resultSet.getInt(3) - 1);
                metaInfo.getFieldMetaInfoList().add(fieldMetaInfo);
            }
            tableName = resultMap;
        }
        catch (SQLException e) {
            try {
                throw new DatabaseException("Unable to get meta info of columns in DB: " + schemaName, e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                JdbcUtils.close(stmt);
                JdbcUtils.close(conn);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet);
        JdbcUtils.close(stmt);
        JdbcUtils.close(conn);
        return tableName;
    }

    public static TableFieldMetaInfo getTableFieldMetaInfo(Connection conn, String schemaName, String tableName, List<String> columnNames) throws DatabaseException {
        TableFieldMetaInfo tableFieldMetaInfo = DbUtil.getTableFieldMetaInfo(conn, schemaName, tableName);
        if (columnNames == null || columnNames.isEmpty()) {
            return tableFieldMetaInfo;
        }
        List<FieldMetaInfo> fieldMetaInfoList = tableFieldMetaInfo.getFieldMetaInfoList();
        Map<String, FieldMetaInfo> colMetaMap = fieldMetaInfoList.stream().collect(Collectors.toMap(FieldMetaInfo::getName, c -> c));
        ArrayList<FieldMetaInfo> resMetaInfoList = new ArrayList<FieldMetaInfo>();
        for (String col : columnNames) {
            FieldMetaInfo metaInfo = colMetaMap.get(col);
            if (metaInfo == null) {
                throw new IllegalArgumentException(String.format("Unknown column %s in %s", col, tableName));
            }
            resMetaInfoList.add(metaInfo);
        }
        tableFieldMetaInfo.setFieldMetaInfoList(resMetaInfoList);
        return tableFieldMetaInfo;
    }

    public static PartitionKey getPartitionKey(Connection conn, String schemaName, String tableName) throws DatabaseException {
        PartitionKey partitionKey;
        String partitionInfo = String.format(PARTITION_KEY_SQL_PATTERN, tableName);
        Statement stmt = null;
        ResultSet resultSet = null;
        PartitionKey partitionKey2 = new PartitionKey();
        try {
            stmt = conn.createStatement();
            resultSet = stmt.executeQuery(partitionInfo);
            if (!resultSet.next()) {
                throw new DatabaseException("Unable to get partition key of " + tableName);
            }
            String keyName = resultSet.getString("DB_PARTITION_KEY");
            int dbPartitionCount = resultSet.getInt("DB_PARTITION_COUNT");
            int tbPartitionCount = resultSet.getInt("TB_PARTITION_COUNT");
            partitionKey2.setDbPartitionCount(dbPartitionCount);
            partitionKey2.setTbPartitionCount(tbPartitionCount);
            String keyInfoSql = String.format(PARTITION_KEY_INFO_SQL_PATTERN, schemaName, tableName, keyName);
            stmt = conn.createStatement();
            resultSet = stmt.executeQuery(keyInfoSql);
            if (!resultSet.next()) {
                throw new DatabaseException("Unable to get partition key of " + tableName);
            }
            FieldMetaInfo fieldMetaInfo = new FieldMetaInfo();
            fieldMetaInfo.setName(keyName);
            fieldMetaInfo.setType(resultSet.getString(1));
            fieldMetaInfo.setIndex(resultSet.getInt(2) - 1);
            partitionKey2.setFieldMetaInfo(fieldMetaInfo);
            partitionKey = partitionKey2;
        }
        catch (SQLException e) {
            try {
                throw new DatabaseException("Unable to get partition key of " + tableName, e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                JdbcUtils.close(stmt);
                JdbcUtils.close(conn);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet);
        JdbcUtils.close(stmt);
        JdbcUtils.close(conn);
        return partitionKey;
    }

    @Deprecated
    public static int getPartitionIndex(String value, PartitionKey partitionKey) {
        int partitionSize = partitionKey.getPartitionSize();
        switch (partitionKey.getFieldMetaInfo().getType()) {
            case STRING: {
                return Math.abs(value.hashCode()) % partitionSize;
            }
            case INT: {
                return (int)(Math.abs(Long.parseLong(value)) % (long)partitionSize);
            }
        }
        throw new UnsupportedOperationException("Unsupported partition key type!");
    }

    public static String formatPkConditions(List<PrimaryKey> pkList, List<String> values) {
        Object[] pkConditions = new String[pkList.size()];
        for (int i = 0; i < pkList.size(); ++i) {
            pkConditions[i] = pkList.get(i).getName() + "='" + values.get(i) + "'";
        }
        return StringUtils.join(pkConditions, " AND ");
    }

    private static String getMultiFieldMetaInfoSql(String schemaName, String tableName, List<String> orderByColumnNameList) {
        ArrayList<String> columnConditionList = new ArrayList<String>(orderByColumnNameList.size());
        for (String colName : orderByColumnNameList) {
            columnConditionList.add("'" + colName + "'");
        }
        return String.format(MULTI_FIELD_INFO_SQL_PATTERN, schemaName, tableName, StringUtils.join(columnConditionList, ","));
    }

    public static List<FieldMetaInfo> getFieldMetaInfoListByColNames(Connection conn, String schemaName, String tableName, List<String> orderByColumnNameList) throws DatabaseException {
        ArrayList<FieldMetaInfo> arrayList;
        FieldMetaInfo fieldMetaInfo;
        Statement stmt = null;
        ResultSet resultSet = null;
        String metaInfoSql = DbUtil.getMultiFieldMetaInfoSql(schemaName, tableName, orderByColumnNameList);
        ArrayList<FieldMetaInfo> fieldMetaInfoList = new ArrayList<FieldMetaInfo>(orderByColumnNameList.size());
        for (String colName : orderByColumnNameList) {
            fieldMetaInfo = new FieldMetaInfo();
            fieldMetaInfo.setName(colName);
            fieldMetaInfoList.add(fieldMetaInfo);
        }
        try {
            stmt = conn.createStatement();
            resultSet = stmt.executeQuery(metaInfoSql);
            int foundColCount = 0;
            while (resultSet.next()) {
                String curColName = resultSet.getString(1);
                for (int i = 0; i < fieldMetaInfoList.size(); ++i) {
                    fieldMetaInfo = (FieldMetaInfo)fieldMetaInfoList.get(i);
                    if (!fieldMetaInfo.getName().equalsIgnoreCase(curColName)) continue;
                    ++foundColCount;
                    fieldMetaInfo.setType(resultSet.getString(2));
                    fieldMetaInfo.setIndex(resultSet.getInt(3) - 1);
                }
            }
            if (foundColCount != orderByColumnNameList.size()) {
                throw new DatabaseException("Wrong order by columns" + orderByColumnNameList);
            }
            arrayList = fieldMetaInfoList;
        }
        catch (SQLException e) {
            try {
                throw new DatabaseException("Wrong order by columns" + orderByColumnNameList, e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                JdbcUtils.close(stmt);
                JdbcUtils.close(conn);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet);
        JdbcUtils.close(stmt);
        JdbcUtils.close(conn);
        return arrayList;
    }

    public static long getTableRowCount(Connection conn, String tableName) throws DatabaseException {
        long l;
        Statement stmt = null;
        ResultSet resultSet = null;
        String metaInfoSql = String.format(ROW_COUNT_SQL_PATTERN, tableName);
        try {
            stmt = conn.createStatement();
            resultSet = stmt.executeQuery(metaInfoSql);
            if (!resultSet.next()) {
                throw new DatabaseException("Cannot get row count of " + tableName);
            }
            l = resultSet.getLong(1);
        }
        catch (SQLException e) {
            try {
                throw new DatabaseException("Cannot get row count of " + tableName, e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                JdbcUtils.close(stmt);
                JdbcUtils.close(conn);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet);
        JdbcUtils.close(stmt);
        JdbcUtils.close(conn);
        return l;
    }

    public static void useDb(Connection conn, String dbName) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            stmt.execute("use " + dbName);
        }
    }

    public static List<String> getAllTablesInDb(Connection conn, String dbName) throws DatabaseException {
        ArrayList<String> arrayList;
        block9: {
            ArrayList<String> allTables = new ArrayList<String>();
            Statement stmt = conn.createStatement();
            try {
                ResultSet rs = stmt.executeQuery("show tables");
                while (rs.next()) {
                    allTables.add(rs.getString(1));
                }
                arrayList = allTables;
                if (stmt == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new DatabaseException("Failed to show tables in:" + dbName, e);
                }
            }
            stmt.close();
        }
        return arrayList;
    }

    public static String getShowCreateDatabase(Connection conn, String dbName) throws DatabaseException {
        String string;
        block9: {
            Statement stmt = conn.createStatement();
            try {
                ResultSet rs = stmt.executeQuery("show create database " + dbName);
                if (!rs.next()) {
                    throw new DatabaseException("Failed to show create database:" + dbName);
                }
                string = rs.getString(2);
                if (stmt == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new DatabaseException("Failed to show create database:" + dbName, e);
                }
            }
            stmt.close();
        }
        return string;
    }

    public static String getShowCreateTable(Connection conn, String tableName) throws DatabaseException {
        String string;
        block9: {
            Statement stmt = conn.createStatement();
            try {
                ResultSet rs = stmt.executeQuery(String.format("show create table `%s`", tableName));
                if (!rs.next()) {
                    throw new DatabaseException("Failed to show create table:" + tableName);
                }
                string = rs.getString(2);
                if (stmt == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new DatabaseException("Failed to show create table:" + tableName, e);
                }
            }
            stmt.close();
        }
        return string;
    }

    public static boolean checkTableExists(Connection conn, String tableName) throws DatabaseException {
        boolean bl;
        block8: {
            Statement stmt = conn.createStatement();
            try {
                ResultSet rs = stmt.executeQuery(String.format("show tables like '%s'", tableName));
                bl = rs.next();
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new DatabaseException("Failed to check table existence: " + tableName, e);
                }
            }
            stmt.close();
        }
        return bl;
    }

    public static boolean checkDatabaseExists(Connection conn, String dbName) throws DatabaseException {
        try {
            DbUtil.useDb(conn, dbName);
        }
        catch (SQLException e) {
            if (e.getMessage().contains("Unknown database")) {
                return false;
            }
            throw new DatabaseException("Failed to check database existence: " + dbName, e);
        }
        return true;
    }

    public static String getPrepareInsertSql(String tableName, int fieldCount, boolean ignore) {
        if (fieldCount <= 0) {
            throw new IllegalArgumentException("Insert value should be at lease 1");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("INSERT ");
        if (ignore) {
            stringBuilder.append("IGNORE ");
        }
        stringBuilder.append("INTO ").append(tableName).append(" VALUES (?");
        for (int i = 0; i < fieldCount - 1; ++i) {
            stringBuilder.append(",?");
        }
        stringBuilder.append(");");
        return stringBuilder.toString();
    }

    /*
     * Exception decompiling
     */
    public static boolean isBroadCast(Connection conn, String tableName) throws DatabaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

