/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import model.db.FieldMetaInfo;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);
    public static final String NULL_STR = "NULL";
    public static final ByteBuffer NULL_STR_WITH_COMMA_BYTE_BUFFER = ByteBuffer.wrap("NULL,".getBytes());
    public static final byte[] NULL_STR_BYTE = "NULL".getBytes();
    public static final ByteBuffer NULL_STR_BYTE_BUFFER = ByteBuffer.wrap(NULL_STR_BYTE);
    public static final String NULL_ESC_STR = "\\N";
    public static final String NULL_ESC_STR_IN_QUOTE = "\\\\N";
    public static final byte[] DOUBLE_QUOTE_BYTE = "\"".getBytes();
    public static final byte[] BACK_SLASH_BYTE = "\\".getBytes();
    public static final byte[] NULL_ESC_BYTE = "\\N".getBytes();
    public static final byte[] NULL_ESC_BYTE_IN_QUOTE = "\\\\N".getBytes();
    public static final byte[] LF_BYTE = "\n".getBytes();
    public static final byte[] CR_BYTE = "\r".getBytes();
    public static final byte[] SYS_NEW_LINE_BYTE = System.lineSeparator().getBytes();
    public static final ByteBuffer NEW_LINE_BYTE_BUFFER = ByteBuffer.wrap(SYS_NEW_LINE_BYTE);

    public static void writeToByteArrayStream(ByteArrayOutputStream os, byte[] value) throws IOException {
        if (value != null) {
            FileUtil.writeWithQuoteEscape(os, value);
        } else {
            os.write(NULL_ESC_BYTE);
        }
    }

    public static void writeToByteArrayStreamInQuote(ByteArrayOutputStream os, byte[] value) throws IOException {
        if (value != null) {
            FileUtil.writeWithQuoteEscapeInQuote(os, value);
        } else {
            os.write(NULL_ESC_BYTE_IN_QUOTE);
        }
    }

    private static void writeWithQuoteEscape(ByteArrayOutputStream os, byte[] value) {
        byte quoteByte = DOUBLE_QUOTE_BYTE[0];
        for (byte b : value) {
            if (b == quoteByte) {
                os.write(quoteByte);
                os.write(quoteByte);
                continue;
            }
            os.write(b);
        }
    }

    private static void writeWithQuoteEscapeInQuote(ByteArrayOutputStream os, byte[] value) {
        byte quoteByte = DOUBLE_QUOTE_BYTE[0];
        byte backSlashByte = BACK_SLASH_BYTE[0];
        for (byte b : value) {
            if (b == quoteByte) {
                os.write(quoteByte);
                os.write(quoteByte);
                continue;
            }
            if (b == backSlashByte) {
                os.write(backSlashByte);
                os.write(backSlashByte);
                continue;
            }
            os.write(b);
        }
    }

    public static void writeToByteArrayStreamWithQuote(ByteArrayOutputStream os, byte[] value) throws IOException {
        os.write(DOUBLE_QUOTE_BYTE);
        FileUtil.writeToByteArrayStreamInQuote(os, value);
        os.write(DOUBLE_QUOTE_BYTE);
    }

    public static byte[] getHeaderBytes(List<FieldMetaInfo> metaInfoList, byte[] separator) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int len = metaInfoList.size();
        try {
            for (int i = 0; i < len - 1; ++i) {
                FileUtil.writeToByteArrayStream(os, metaInfoList.get(i).getName().getBytes());
                os.write(separator);
            }
            FileUtil.writeToByteArrayStream(os, metaInfoList.get(len - 1).getName().getBytes());
            os.write(SYS_NEW_LINE_BYTE);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return os.toByteArray();
    }

    public static ByteBuffer getNullStrWithCommaByteBuffer() {
        NULL_STR_WITH_COMMA_BYTE_BUFFER.rewind();
        return NULL_STR_WITH_COMMA_BYTE_BUFFER;
    }

    public static List<String> split(String line, String sep, boolean withLastSep, boolean hasEscapedQuote) {
        return FileUtil.splitWithEstimateCount(line, sep, withLastSep, 16, hasEscapedQuote);
    }

    public static List<String> splitWithEstimateCount(String line, String sep, boolean withLastSep, int estimateCount, boolean hasEscapedQuote) {
        return FileUtil.splitWithQuoteEscape(line, sep, withLastSep, estimateCount, hasEscapedQuote);
    }

    public static String[] split(String line, String sep, boolean withLastSep, int expectedCount, boolean hasEscapedQuote) {
        ArrayList<String> values = FileUtil.splitWithQuoteEscape(line, sep, withLastSep, expectedCount, hasEscapedQuote);
        if (values.size() != expectedCount) {
            FileUtil.badFormatException(line, expectedCount, values.size());
        }
        return values.toArray(new String[values.size()]);
    }

    private static ArrayList<String> splitWithQuoteEscape(String line, String sep, boolean withLastSep, int estimateCount, boolean hasEscapedQuote) {
        char[] chars = line.toCharArray();
        int len = chars.length;
        if (withLastSep) {
            len -= sep.length();
        }
        ArrayList<String> subStrings = new ArrayList<String>(estimateCount);
        StringBuilder stringBuilder = new StringBuilder(line.length() / estimateCount);
        char sepStart = sep.charAt(0);
        boolean enclosingByQuote = false;
        boolean endsWithSep = false;
        for (int i = 0; i < len; ++i) {
            if (i == len - 1) {
                if (chars[i] == '\"') {
                    if (hasEscapedQuote) {
                        stringBuilder.append(chars[i]);
                    }
                    subStrings.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    break;
                }
                if (chars[i] != '\"') {
                    if (!hasEscapedQuote && enclosingByQuote) {
                        FileUtil.badFormatException("Unclosed quote", line);
                        break;
                    }
                    if (sep.length() == 1 && chars[i] == sepStart) {
                        endsWithSep = true;
                    } else {
                        stringBuilder.append(chars[i]);
                    }
                    subStrings.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    break;
                }
                FileUtil.badFormatException("Failed to split", line);
            }
            if (chars[i] == '\"' && !hasEscapedQuote) {
                if (!enclosingByQuote) {
                    enclosingByQuote = true;
                    continue;
                }
                if (i + 1 < len) {
                    if (chars[i + 1] == '\"') {
                        stringBuilder.append('\"');
                        ++i;
                        continue;
                    }
                    subStrings.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    enclosingByQuote = false;
                    i += sep.length();
                    continue;
                }
                subStrings.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                enclosingByQuote = false;
                continue;
            }
            if (chars[i] == sepStart && !enclosingByQuote) {
                int j = i + 1;
                int end = j + sep.length() - 1;
                int k = 1;
                while (j < end && chars[j] == sep.charAt(k)) {
                    ++j;
                    ++k;
                }
                if (j == end) {
                    subStrings.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    enclosingByQuote = false;
                    if ((i += sep.length() - 1) != len - 1) continue;
                    endsWithSep = true;
                    continue;
                }
                stringBuilder.append(chars[i]);
                continue;
            }
            stringBuilder.append(chars[i]);
        }
        if (endsWithSep && !withLastSep) {
            subStrings.add("");
        }
        return subStrings;
    }

    private static void badFormatException(String msg, String line) {
        throw new IllegalArgumentException(msg + " in line: " + line);
    }

    private static void badFormatException(String line, int expectedCount, int actualCount) throws IllegalFormatException {
        throw new IllegalArgumentException(String.format("Bad format line: %s. Expected field count: %d, found: %d", line, expectedCount, actualCount));
    }

    public static String trimEndAndMoveQuote(String s2) {
        int len;
        char[] chars = s2.toCharArray();
        int st = 0;
        for (len = chars.length; st < len && chars[len - 1] <= ' '; --len) {
        }
        while (st < len && chars[st] <= ' ') {
            ++st;
        }
        if (len >= 2 && chars[len - 1] == '\"' && chars[st] == '\"') {
            String tmp;
            if ((tmp = s2.substring(++st, --len)).contains("\"\"")) {
                return tmp.replaceAll("\"\"", "\"");
            }
            return tmp;
        }
        return len < chars.length ? s2.substring(0, len) : s2;
    }

    public static boolean containsSpecialBytes(byte[] source, List<byte[]> targetList) {
        if (source == null || source.length == 0) {
            return false;
        }
        int specialCharCount = targetList.size();
        boolean minTargetLen = true;
        int max = source.length - 1;
        for (int src_i = 0; src_i <= max; ++src_i) {
            for (int n = 0; n < specialCharCount; ++n) {
                byte[] cur = targetList.get(n);
                byte first = cur[0];
                int targetLen = cur.length;
                if (source[src_i] != first) continue;
                int src_j = src_i + 1;
                int end = src_j + targetLen - 1;
                int k = 1;
                while (src_j < end && source[src_j] == cur[k]) {
                    ++src_j;
                    ++k;
                }
                if (src_j != end) continue;
                return true;
            }
        }
        return false;
    }

    public static String getFilePathPrefix(String path, String filenamePrefix, String tableName) {
        return String.format("%s%s%s_", path, filenamePrefix, tableName);
    }

    public static Map<String, List<File>> getDataFile(String baseDirectory) {
        File dir = new File(baseDirectory);
        if (!dir.isDirectory()) {
            logger.error("Not valid directory.");
            return null;
        }
        HashMap<String, List<File>> result = new HashMap<String, List<File>>();
        for (File file : Objects.requireNonNull(dir.listFiles())) {
            if (!file.isFile()) continue;
            String[] items = file.getName().split("\\.");
            if (items.length < 3) {
                logger.error("Error file name: " + file.getName());
                return null;
            }
            String tableName = items[2].toLowerCase();
            List fileList = result.computeIfAbsent(tableName, k -> new ArrayList());
            fileList.add(file);
        }
        return result;
    }

    public static List<String> getFilesAbsPathInDir(String dirPathStr) {
        File dir = new File(dirPathStr);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IllegalArgumentException(String.format("[%s] does not exist or is not a directory", dirPathStr));
        }
        return FileUtils.listFiles(dir, null, false).stream().filter(file -> file.isFile() && file.canRead() && !file.getName().endsWith(".ddl")).map(File::getAbsolutePath).collect(Collectors.toList());
    }

    public static String getFileAbsPath(String filename) {
        File file = new File(filename);
        if (!(file.exists() && file.isFile() && file.canRead())) {
            throw new IllegalArgumentException("Failed to read from " + filename);
        }
        return file.getAbsolutePath();
    }

    public static RandomAccessFile openRafForRead(File file) {
        try {
            return new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

