/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FileUtils;

public class IOUtil {
    public static FileChannel createEmptyFileAndOpenChannel(String tmpFileName) {
        File file = new File(tmpFileName);
        FileUtils.deleteQuietly(file);
        try {
            file.createNewFile();
            return FileChannel.open(Paths.get(tmpFileName, new String[0]), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void writeNio(FileChannel fileChannel, byte[] data) throws IOException {
        ByteBuffer src = ByteBuffer.wrap(data);
        int length = fileChannel.write(src);
        while (length != 0) {
            length = fileChannel.write(src);
        }
    }

    public static void close(FileChannel channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void finish(DeflaterOutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.finish();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void close(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static GZIPOutputStream createGzipOutputStream(FileChannel channel) {
        try {
            return new GZIPOutputStream(Channels.newOutputStream(channel), 65536);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void flush(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static GZIPInputStream createGzipInputStream() {
        try {
            return new GZIPInputStream((InputStream)new ByteArrayInputStream(new byte[32768]), 65536);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

