/*
 * Decompiled with CFR 0.152.
 */
package worker;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.WorkerPool;
import com.lmax.disruptor.dsl.ProducerType;
import model.config.GlobalVar;
import worker.EventExceptionHandler;

public class MyWorkerPool {
    public static <T> RingBuffer<T> createRingBuffer(EventFactory<T> factory) {
        return RingBuffer.create(ProducerType.MULTI, factory, GlobalVar.DEFAULT_RING_BUFFER_SIZE, new BlockingWaitStrategy());
    }

    public static <T> RingBuffer<T> createSingleProducerRingBuffer(EventFactory<T> factory) {
        return RingBuffer.create(ProducerType.SINGLE, factory, GlobalVar.DEFAULT_RING_BUFFER_SIZE, new BlockingWaitStrategy());
    }

    public static <T> RingBuffer<T> createRingBuffer(EventFactory<T> factory, int bufferSize) {
        return RingBuffer.create(ProducerType.MULTI, factory, bufferSize, new BlockingWaitStrategy());
    }

    @SafeVarargs
    public static <T> WorkerPool<T> createWorkerPool(RingBuffer<T> ringBuffer, WorkHandler<T> ... consumers) {
        SequenceBarrier barriers = ringBuffer.newBarrier(new Sequence[0]);
        WorkerPool<T> workerPool = new WorkerPool<T>(ringBuffer, barriers, new EventExceptionHandler(), consumers);
        ringBuffer.addGatingSequences(workerPool.getWorkerSequences());
        return workerPool;
    }
}

