/*
 * Decompiled with CFR 0.152.
 */
package worker;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedThreadFactory
implements ThreadFactory {
    private static final Logger logger = LoggerFactory.getLogger(NamedThreadFactory.class);
    private static final AtomicInteger poolNumber = new AtomicInteger();
    private final AtomicInteger threadNumber = new AtomicInteger();
    private final ThreadGroup group;
    private final String namePrefix;
    private final boolean isDaemon;
    private final Thread.UncaughtExceptionHandler handler = (t, e) -> logger.error("{}", e);

    public NamedThreadFactory() {
        this("pool");
    }

    public NamedThreadFactory(String prefix) {
        this(prefix, false);
    }

    public NamedThreadFactory(String prefix, boolean daemon) {
        SecurityManager s2 = System.getSecurityManager();
        this.group = s2 != null ? s2.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = prefix + "-" + poolNumber.getAndIncrement() + "-thread-";
        this.isDaemon = daemon;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        t.setDaemon(this.isDaemon);
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        t.setUncaughtExceptionHandler(this.handler);
        return t;
    }
}

