/*
 * Decompiled with CFR 0.152.
 */
package worker.common;

import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.FileUtil;
import worker.common.BaseWorkHandler;
import worker.common.BatchLineEvent;

public abstract class BaseDefaultConsumer
extends BaseWorkHandler {
    private static final Logger logger = LoggerFactory.getLogger(BaseDefaultConsumer.class);
    protected int estimateFieldCount = 16;

    @Override
    protected void initLocalVars() {
        super.initLocalVars();
    }

    @Override
    public void onProxyEvent(BatchLineEvent event) {
        if (this.consumerContext.getException() != null) {
            return;
        }
        this.initLocalVars();
        try {
            String[] lines = event.getBatchLines();
            int estimateLineSize = 10;
            if (lines.length > 0 && lines[0] != null) {
                estimateLineSize = Math.min(estimateLineSize, lines[0].length());
            }
            StringBuilder stringBuilder = new StringBuilder(lines.length * estimateLineSize);
            for (String line : lines) {
                if (StringUtils.isEmpty(line)) continue;
                if (line == "END_OF_BATCH_LINES") break;
                List<String> values = FileUtil.splitWithEstimateCount(line, this.sep, this.consumerContext.isWithLastSep(), this.estimateFieldCount, this.hasEscapedQuote);
                this.fillLocalBuffer(stringBuilder, values);
            }
            if (stringBuilder.length() > 0) {
                this.execSql(stringBuilder);
            }
        }
        catch (Exception e) {
            this.consumerContext.setException(e);
            logger.error("Failed in table [{}], due to {}", (Object)this.tableName, (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            this.consumerContext.getEmittedDataCounter().getAndDecrement();
            if (this.consumerContext.isUseBlock()) {
                this.consumerContext.getEventCounter().get(event.getLocalProcessingFileIndex()).get(event.getLocalProcessingBlockIndex()).getAndDecrement();
            }
        }
    }

    protected abstract void fillLocalBuffer(StringBuilder var1, List<String> var2);

    protected abstract String getSql(StringBuilder var1);

    protected void execSql(StringBuilder data) throws SQLException {
        Connection conn = null;
        Statement stmt = null;
        String sql = null;
        try {
            conn = this.consumerContext.getDataSource().getConnection();
            stmt = conn.createStatement();
            sql = this.getSql(data);
            stmt.execute(sql);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JdbcUtils.close(stmt);
                JdbcUtils.close(conn);
                throw throwable;
            }
        }
        JdbcUtils.close(stmt);
        JdbcUtils.close(conn);
    }
}

