/*
 * Decompiled with CFR 0.152.
 */
package worker.common;

import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import model.db.FieldMetaInfo;
import model.db.PartitionKey;
import model.db.TableTopology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.DbUtil;
import util.FileUtil;
import worker.common.BaseWorkHandler;
import worker.common.BatchLineEvent;

public abstract class BaseShardedConsumer
extends BaseWorkHandler {
    private static final Logger logger = LoggerFactory.getLogger(BaseShardedConsumer.class);

    @Override
    protected void initLocalVars() {
        super.initLocalVars();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onProxyEvent(BatchLineEvent event) {
        this.initLocalVars();
        try {
            String[] lines;
            List<TableTopology> topologyList = this.consumerContext.getTopologyList(this.tableName);
            List<FieldMetaInfo> fieldMetaInfoList = this.consumerContext.getTableFieldMetaInfo(this.tableName).getFieldMetaInfoList();
            int shardCount = topologyList.size();
            PartitionKey partitionKey = this.consumerContext.getTablePartitionKey(this.tableName);
            StringBuilder[] dataBuffers = new StringBuilder[shardCount];
            for (int i = 0; i < shardCount; ++i) {
                dataBuffers[i] = new StringBuilder();
            }
            StringBuilder localBuffer = new StringBuilder();
            for (String line : lines = event.getBatchLines()) {
                if (StringUtils.isEmpty(line)) continue;
                if (line == "END_OF_BATCH_LINES") break;
                List<String> values = FileUtil.split(line, this.sep, this.consumerContext.isWithLastSep(), this.hasEscapedQuote);
                String partitionFieldValue = values.get(partitionKey.getFieldMetaInfo().getIndex());
                int partitionIndex = DbUtil.getPartitionIndex(partitionFieldValue, partitionKey);
                try {
                    this.fillLocalBuffer(localBuffer, values, fieldMetaInfoList);
                }
                catch (Throwable e) {
                    logger.error("{} at line: {}", (Object)e.getMessage(), (Object)line);
                    localBuffer.setLength(0);
                    continue;
                }
                dataBuffers[partitionIndex].append((CharSequence)localBuffer);
                localBuffer.setLength(0);
            }
            for (int i = 0; i < shardCount; ++i) {
                if (dataBuffers[i].length() == 0) continue;
                this.execSqlWithShardingHint(topologyList.get(i), dataBuffers[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            System.exit(1);
        }
        finally {
            this.consumerContext.getEmittedDataCounter().getAndDecrement();
            if (this.consumerContext.isUseBlock()) {
                this.consumerContext.getEventCounter().get(event.getLocalProcessingFileIndex()).get(event.getLocalProcessingBlockIndex()).getAndDecrement();
            }
        }
    }

    protected abstract void fillLocalBuffer(StringBuilder var1, List<String> var2, List<FieldMetaInfo> var3) throws Throwable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execSqlWithShardingHint(TableTopology topology, StringBuilder data) {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.consumerContext.getDataSource().getConnection();
            stmt = conn.createStatement();
            String sql = this.getSqlWithHint(topology, data);
            stmt.execute(sql);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                logger.error(e.getMessage());
                System.exit(1);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(stmt);
                JdbcUtils.close(conn);
                throw throwable;
            }
            JdbcUtils.close(stmt);
            JdbcUtils.close(conn);
        }
        JdbcUtils.close(stmt);
        JdbcUtils.close(conn);
    }

    protected abstract String getSqlWithHint(TableTopology var1, StringBuilder var2);
}

