/*
 * Decompiled with CFR 0.152.
 */
package worker.common;

import com.google.common.util.concurrent.RateLimiter;
import com.lmax.disruptor.WorkHandler;
import model.ConsumerExecutionContext;
import model.config.GlobalVar;
import worker.common.BatchLineEvent;

public abstract class BaseWorkHandler
implements WorkHandler<BatchLineEvent> {
    protected ConsumerExecutionContext consumerContext;
    private RateLimiter rateLimiter = null;
    protected boolean hasEscapedQuote = false;
    protected String sep;
    protected String tableName;

    protected void initLocalVars() {
        if (GlobalVar.IN_PERF_MODE) {
            this.sep = this.consumerContext.getSeparator();
            this.hasEscapedQuote = true;
            return;
        }
        if (this.consumerContext.isUseMagicSeparator()) {
            this.sep = "|@|";
            this.hasEscapedQuote = true;
        } else {
            this.sep = this.consumerContext.getSeparator();
            this.hasEscapedQuote = false;
        }
    }

    public void setConsumerContext(ConsumerExecutionContext consumerContext) {
        this.consumerContext = consumerContext;
    }

    public void createTpsLimiter(double tpsLimit) {
        if (tpsLimit > 0.0) {
            this.rateLimiter = RateLimiter.create(tpsLimit);
        }
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public void onEvent(BatchLineEvent event) {
        if (this.rateLimiter != null) {
            this.rateLimiter.acquire(1);
        }
        this.onProxyEvent(event);
    }

    public abstract void onProxyEvent(BatchLineEvent var1);
}

