/*
 * Decompiled with CFR 0.152.
 */
package worker.common;

import com.google.common.base.Preconditions;
import com.lmax.disruptor.RingBuffer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import model.ProducerExecutionContext;
import model.config.FileLineRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import worker.common.BatchLineEvent;
import worker.common.Producer;

public abstract class ReadFileProducer
implements Producer {
    private static final Logger logger = LoggerFactory.getLogger(ReadFileProducer.class);
    final ProducerExecutionContext context;
    final RingBuffer<BatchLineEvent> ringBuffer;
    protected final List<File> fileList;
    protected final List<FileLineRecord> fileLineRecordList;

    public ReadFileProducer(ProducerExecutionContext context, RingBuffer<BatchLineEvent> ringBuffer, List<FileLineRecord> fileLineRecordList) {
        this.context = context;
        this.ringBuffer = ringBuffer;
        Preconditions.checkArgument(!fileLineRecordList.isEmpty(), "No file for producer");
        this.fileLineRecordList = fileLineRecordList;
        this.fileList = new ArrayList<File>(fileLineRecordList.size());
        this.initFileList();
    }

    @Override
    public abstract void produce();

    private void initFileList() {
        for (FileLineRecord fileRecord : this.fileLineRecordList) {
            File file = new File(fileRecord.getFilePath());
            if (!file.exists()) {
                logger.error("File {} doesn't exist", (Object)fileRecord.getFilePath());
                throw new RuntimeException("File doesn't exist");
            }
            this.fileList.add(file);
        }
    }

    public boolean useMagicSeparator() {
        return false;
    }
}

