/*
 * Decompiled with CFR 0.152.
 */
package worker.common;

import com.lmax.disruptor.RingBuffer;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import model.ProducerExecutionContext;
import model.config.CompressMode;
import model.config.FileBlockListRecord;
import model.config.FileLineRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import worker.common.BatchLineEvent;
import worker.common.ReadFileProducer;
import worker.common.reader.BlockReader;

public class ReadFileWithBlockProducer
extends ReadFileProducer {
    private static final Logger logger = LoggerFactory.getLogger(ReadFileWithBlockProducer.class);
    private final CompressMode compressMode;
    private final FileBlockListRecord fileBlockListRecord;

    public ReadFileWithBlockProducer(ProducerExecutionContext context, RingBuffer<BatchLineEvent> ringBuffer, List<FileLineRecord> fileLineRecordList) {
        super(context, ringBuffer, fileLineRecordList);
        this.compressMode = context.getCompressMode();
        this.fileBlockListRecord = new FileBlockListRecord(this.fileList, context.getNextFileIndex(), context.getNextBlockIndex());
    }

    @Override
    public void produce() {
        int parallelism = this.context.getParallelism();
        ThreadPoolExecutor threadPool = this.context.getProducerExecutor();
        BlockReader readFileWorker = null;
        for (int i = 0; i < parallelism; ++i) {
            readFileWorker = new BlockReader(this.context, this.fileBlockListRecord, (RingBuffer<BatchLineEvent>)this.ringBuffer, this.compressMode);
            threadPool.submit(readFileWorker);
        }
    }

    public AtomicBoolean[] getFileDoneList() {
        return this.fileBlockListRecord.getFileDoneList();
    }
}

