/*
 * Decompiled with CFR 0.152.
 */
package worker.common.reader;

import com.lmax.disruptor.RingBuffer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import model.ProducerExecutionContext;
import model.config.CompressMode;
import model.config.FileBlockListRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.FileUtil;
import util.IOUtil;
import worker.common.BatchLineEvent;
import worker.common.reader.FileBufferedBatchReader;

public class BlockReader
extends FileBufferedBatchReader {
    private static final Logger logger = LoggerFactory.getLogger(BlockReader.class);
    private RandomAccessFile curRandomAccessFile;
    private final long readBlockSize;
    private static long READ_PADDING = 4096L;
    private final FileBlockListRecord fileBlockListRecord;
    private final BlockByteBuffer byteBuffer;
    private final BlockPosMarker posMarker;
    private final byte[] gzipBuffer;

    public BlockReader(ProducerExecutionContext context, FileBlockListRecord fileBlockListRecord, RingBuffer<BatchLineEvent> ringBuffer, CompressMode compressMode) {
        super(context, fileBlockListRecord.getFileList(), ringBuffer, compressMode);
        this.readBlockSize = (long)context.getReadBlockSizeInMb() * 1024L * 1024L;
        this.localProcessingFileIndex = fileBlockListRecord.getCurrentFileIndex().get();
        this.fileBlockListRecord = fileBlockListRecord;
        this.curRandomAccessFile = FileUtil.openRafForRead((File)this.fileList.get(this.localProcessingFileIndex));
        this.gzipBuffer = (byte[])(this.compressMode != CompressMode.NONE ? new byte[(int)(this.readBlockSize + READ_PADDING)] : null);
        this.byteBuffer = new BlockByteBuffer((int)(this.readBlockSize + READ_PADDING));
        this.posMarker = new BlockPosMarker();
    }

    @Override
    protected void readData() {
        try {
            while (true) {
                int curReadingPos;
                this.localProcessingBlockIndex = this.fileBlockListRecord.getStartPosArr()[this.localProcessingFileIndex].getAndIncrement();
                long pos = this.localProcessingBlockIndex * this.readBlockSize;
                this.context.getEventCounter().get(this.localProcessingFileIndex).putIfAbsent(this.localProcessingBlockIndex, new AtomicInteger(0));
                this.context.getEventCounter().get(this.localProcessingFileIndex).get(this.localProcessingBlockIndex).incrementAndGet();
                boolean skipFirst = pos != 0L;
                this.seekAndRead(pos);
                if (this.byteBuffer.len == -1) {
                    if (this.nextFile()) continue;
                    break;
                }
                this.preprocessBuffer();
                this.posMarker.reset();
                block6: while ((curReadingPos = this.posMarker.getReadingPos()) < this.byteBuffer.len) {
                    switch (this.byteBuffer.buffer[curReadingPos]) {
                        case 10: {
                            if (skipFirst) {
                                skipFirst = false;
                            } else if (pos != 0L || this.posMarker.curPos != 0 || !this.context.isWithHeader()) {
                                this.handleLine(pos == 0L);
                            }
                            this.posMarker.resetPos(curReadingPos + 1);
                            if ((long)this.posMarker.getReadingPos() <= this.readBlockSize) continue block6;
                            break block6;
                        }
                        default: {
                            ++this.posMarker.curLen;
                            continue block6;
                        }
                    }
                }
                if ((curReadingPos = this.posMarker.getReadingPos()) == this.byteBuffer.len && (long)curReadingPos <= this.readBlockSize) {
                    this.handleLine(pos == 0L);
                }
                this.context.getEventCounter().get(this.localProcessingFileIndex).get(this.localProcessingBlockIndex).getAndDecrement();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
        if (this.bufferedLineCount != 0) {
            this.emitLineBuffer();
        }
    }

    private void handleLine(boolean checkBom) {
        byte[] tmpByteBuffer;
        int curReadingPos = this.posMarker.getReadingPos();
        if (curReadingPos - 1 >= 0 && this.byteBuffer.buffer[curReadingPos - 1] == 13) {
            tmpByteBuffer = new byte[this.posMarker.curLen - 1];
            System.arraycopy(this.byteBuffer.buffer, this.posMarker.curPos, tmpByteBuffer, 0, this.posMarker.curLen - 1);
        } else {
            tmpByteBuffer = new byte[this.posMarker.curLen];
            System.arraycopy(this.byteBuffer.buffer, this.posMarker.curPos, tmpByteBuffer, 0, this.posMarker.curLen);
        }
        int bytesEnd = tmpByteBuffer.length - 1;
        int bytesOffset = 0;
        if (checkBom && bytesEnd >= 2 && this.context.isUtfCharset() && tmpByteBuffer[0] == -17 && tmpByteBuffer[1] == -69 && tmpByteBuffer[2] == -65) {
            bytesOffset = 3;
        }
        while (bytesEnd >= bytesOffset && tmpByteBuffer[bytesEnd] <= 32) {
            --bytesEnd;
        }
        if (bytesEnd < bytesOffset) {
            return;
        }
        String line = new String(tmpByteBuffer, bytesOffset, bytesEnd - bytesOffset + 1, this.context.getCharset());
        this.appendToLineBuffer(line);
    }

    private void seekAndRead(long pos) {
        try {
            this.curRandomAccessFile.seek(pos);
            this.byteBuffer.len = this.curRandomAccessFile.read(this.byteBuffer.buffer);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private void preprocessBuffer() {
        try {
            if (this.compressMode == CompressMode.GZIP) {
                GZIPInputStream gzipInputStream = new GZIPInputStream((InputStream)new ByteArrayInputStream(this.byteBuffer.buffer), 65536);
                ByteArrayOutputStream gzipOutputBuffer = new ByteArrayOutputStream(this.byteBuffer.len * 2);
                int num = 0;
                while ((num = gzipInputStream.read(this.gzipBuffer, 0, this.byteBuffer.len)) != -1) {
                    gzipOutputBuffer.write(this.gzipBuffer, 0, num);
                }
                this.byteBuffer.reload(gzipOutputBuffer.toByteArray());
                gzipInputStream.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private boolean nextFile() {
        if (this.fileBlockListRecord.getFileDoneList()[this.localProcessingFileIndex].compareAndSet(false, true)) {
            logger.info("{} reading is finished", (Object)((File)this.fileList.get(this.localProcessingFileIndex)).getPath());
        }
        this.context.getEventCounter().get(this.localProcessingFileIndex).get(this.localProcessingBlockIndex).getAndDecrement();
        if (this.localProcessingFileIndex < this.fileList.size() - 1) {
            this.fileBlockListRecord.getCurrentFileIndex().compareAndSet(this.localProcessingFileIndex, this.localProcessingFileIndex + 1);
            ++this.localProcessingFileIndex;
            this.localProcessingBlockIndex = -1L;
            this.curRandomAccessFile = FileUtil.openRafForRead((File)this.fileList.get(this.localProcessingFileIndex));
            return true;
        }
        return false;
    }

    @Override
    protected void beforePublish() {
        this.context.getEmittedDataCounter().getAndIncrement();
        this.context.getEventCounter().get(this.localProcessingFileIndex).get(this.localProcessingBlockIndex).getAndIncrement();
    }

    @Override
    protected void close() {
        IOUtil.close(this.curRandomAccessFile);
    }

    private static class BlockPosMarker {
        int curPos = 0;
        int curLen = 0;

        int getReadingPos() {
            return this.curPos + this.curLen;
        }

        void reset() {
            this.curPos = 0;
            this.curLen = 0;
        }

        void resetPos(int newPos) {
            this.curPos = newPos;
            this.curLen = 0;
        }
    }

    private static class BlockByteBuffer {
        byte[] buffer;
        int len;

        BlockByteBuffer(int size) {
            this.buffer = new byte[size];
            this.len = 0;
        }

        int getCapacity() {
            return this.buffer.length;
        }

        void reload(byte[] data) {
            this.buffer = data;
            this.len = data.length;
        }
    }
}

