/*
 * Decompiled with CFR 0.152.
 */
package worker.common.reader;

import com.lmax.disruptor.RingBuffer;
import java.io.File;
import java.util.List;
import model.ProducerExecutionContext;
import model.config.CompressMode;
import model.config.GlobalVar;
import worker.common.BatchLineEvent;

public abstract class FileBufferedBatchReader
implements Runnable {
    protected final RingBuffer<BatchLineEvent> ringBuffer;
    protected int bufferedLineCount = 0;
    protected String[] lineBuffer;
    protected volatile int localProcessingFileIndex;
    protected long localProcessingBlockIndex = -1L;
    protected final CompressMode compressMode;
    protected final ProducerExecutionContext context;
    protected final List<File> fileList;

    protected FileBufferedBatchReader(ProducerExecutionContext context, List<File> fileList, RingBuffer<BatchLineEvent> ringBuffer) {
        this(context, fileList, ringBuffer, CompressMode.NONE);
    }

    protected FileBufferedBatchReader(ProducerExecutionContext context, List<File> fileList, RingBuffer<BatchLineEvent> ringBuffer, CompressMode compressMode) {
        this.context = context;
        this.ringBuffer = ringBuffer;
        this.fileList = fileList;
        this.lineBuffer = new String[GlobalVar.EMIT_BATCH_SIZE];
        this.compressMode = compressMode;
    }

    protected void appendToLineBuffer(String line) {
        this.lineBuffer[this.bufferedLineCount++] = line;
        if (this.bufferedLineCount == GlobalVar.EMIT_BATCH_SIZE) {
            this.emitLineBuffer();
            this.lineBuffer = new String[GlobalVar.EMIT_BATCH_SIZE];
            this.bufferedLineCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void emitLineBuffer() {
        long sequence = this.ringBuffer.next();
        try {
            BatchLineEvent event = this.ringBuffer.get(sequence);
            if (this.bufferedLineCount < GlobalVar.EMIT_BATCH_SIZE) {
                this.lineBuffer[this.bufferedLineCount] = "END_OF_BATCH_LINES";
            }
            event.setBatchLines(this.lineBuffer);
            event.setLocalProcessingFileIndex(this.localProcessingFileIndex);
            event.setLocalProcessingBlockIndex(this.localProcessingBlockIndex);
        }
        finally {
            this.beforePublish();
            this.ringBuffer.publish(sequence);
        }
    }

    @Override
    public void run() {
        try {
            this.readData();
        }
        catch (Exception e) {
            this.context.setException(e);
            throw e;
        }
        finally {
            this.afterRun();
        }
    }

    protected abstract void readData();

    private void afterRun() {
        this.context.getCountDownLatch().countDown();
        this.close();
    }

    protected abstract void close();

    protected abstract void beforePublish();

    public boolean useMagicSeparator() {
        return false;
    }
}

