/*
 * Decompiled with CFR 0.152.
 */
package worker.common.writer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPOutputStream;
import javax.annotation.concurrent.NotThreadSafe;
import model.config.CompressMode;
import util.IOUtil;
import worker.common.writer.IFileWriter;

@NotThreadSafe
public class NioFileWriter
implements IFileWriter {
    private FileChannel appendChannel = null;
    private GZIPOutputStream gzipOutputStream = null;
    private final CompressMode compressMode;
    private boolean closed = false;
    private final Charset charset;

    public NioFileWriter(String fileName) {
        this(fileName, CompressMode.NONE);
    }

    public NioFileWriter(CompressMode compressMode) {
        this(compressMode, StandardCharsets.UTF_8);
    }

    public NioFileWriter(CompressMode compressMode, Charset charset) {
        this.charset = charset;
        this.compressMode = compressMode;
    }

    public NioFileWriter(String fileName, CompressMode compressMode) {
        this(fileName, compressMode, StandardCharsets.UTF_8);
    }

    public NioFileWriter(String fileName, CompressMode compressMode, Charset charset) {
        this.compressMode = compressMode;
        this.charset = charset;
        this.openFileChannel(fileName);
    }

    @Override
    public void nextFile(String fileName) {
        this.closeCurFile();
        this.openFileChannel(fileName);
    }

    @Override
    public void write(byte[] data) {
        this.writeNio(data);
    }

    @Override
    public boolean produceByBlock() {
        return true;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closeCurFile();
        this.closed = false;
    }

    private void openFileChannel(String fileName) {
        this.appendChannel = IOUtil.createEmptyFileAndOpenChannel(fileName);
        if (this.compressMode == CompressMode.GZIP) {
            this.gzipOutputStream = IOUtil.createGzipOutputStream(this.appendChannel);
        }
    }

    public void writeNio(byte[] data) {
        if (this.charset != StandardCharsets.UTF_8) {
            data = new String(data, StandardCharsets.UTF_8).getBytes(this.charset);
        }
        try {
            switch (this.compressMode) {
                case NONE: {
                    ByteBuffer src = ByteBuffer.wrap(data);
                    int length = this.appendChannel.write(src);
                    while (length != 0) {
                        length = this.appendChannel.write(src);
                    }
                    break;
                }
                case GZIP: {
                    this.gzipOutputStream.write(data);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void closeCurFile() {
        if (this.compressMode == CompressMode.NONE) {
            IOUtil.close(this.appendChannel);
        } else {
            IOUtil.finish(this.gzipOutputStream);
            IOUtil.close(this.gzipOutputStream);
        }
    }
}

