/*
 * Decompiled with CFR 0.152.
 */
package worker.ddl;

import exception.DatabaseException;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.DbUtil;
import util.IOUtil;

public class DdlExportWorker
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(DdlExportWorker.class);
    private final String filename;
    private BufferedWriter bufferedWriter = null;
    private final DataSource druid;
    private final String dbName;
    private final List<String> tableNames;
    private final boolean isExportWholeDb;
    private static final Pattern DB_MODE_PATTERN = Pattern.compile("/\\* MODE = '(.*)' \\*/$");

    public DdlExportWorker(DataSource druid, String dbName) {
        this.druid = druid;
        this.dbName = dbName;
        try (Connection conn = druid.getConnection();){
            this.tableNames = DbUtil.getAllTablesInDb(conn, dbName);
        }
        catch (DatabaseException | SQLException e) {
            throw new RuntimeException(e);
        }
        this.isExportWholeDb = true;
        this.filename = dbName + ".ddl";
    }

    public DdlExportWorker(DataSource druid, String dbName, List<String> tableNames) {
        this.druid = druid;
        this.dbName = dbName;
        this.tableNames = tableNames;
        this.isExportWholeDb = false;
        this.filename = dbName + ".ddl";
    }

    @Override
    public void run() {
        try {
            this.beforeRun();
            this.exportDdl();
        }
        catch (Throwable t) {
            t.printStackTrace();
            logger.error(t.getMessage());
        }
        finally {
            this.afterRun();
        }
    }

    private void exportDdl() throws Throwable {
        try (Connection conn = this.druid.getConnection();){
            if (this.isExportWholeDb) {
                logger.info("\u5e93\uff1a{} \u5f00\u59cb\u5bfc\u51fa\u5e93\u7ed3\u6784", (Object)this.dbName);
                this.exportDatabaseStructure(conn, this.dbName);
            }
            for (String tableName : this.tableNames) {
                this.exportTableStructure(conn, tableName);
            }
        }
    }

    private void exportDatabaseStructure(Connection conn, String dbName) throws IOException, DatabaseException {
        this.writeCommentForDatabase(dbName);
        String dbDdl = DbUtil.getShowCreateDatabase(conn, dbName);
        Matcher matcher = DB_MODE_PATTERN.matcher(dbDdl);
        if (matcher.find()) {
            String mode = matcher.group(1);
            dbDdl = String.format("%s mode = '%s'", dbDdl, mode);
        }
        this.writeLine(dbDdl + ";");
        this.writeLine("");
        this.writeLine(String.format("use %s;", dbName));
        this.writeLine("");
    }

    private void exportTableStructure(Connection conn, String tableName) throws IOException, DatabaseException {
        logger.info("\u8868\uff1a{} \u5f00\u59cb\u5bfc\u51fa\u8868\u7ed3\u6784", (Object)tableName);
        this.writeCommentForTable(tableName);
        String tableDdl = DbUtil.getShowCreateTable(conn, tableName);
        this.writeLine(tableDdl + ";");
        this.writeLine("");
    }

    private void writeCommentForDatabase(String dbName) throws IOException {
        this.writeLine("--");
        this.writeLine("-- Database structure for database `" + dbName + "`");
        this.writeLine("--");
    }

    private void writeCommentForTable(String tableName) throws IOException {
        this.writeLine("--");
        this.writeLine("-- Table structure for table `" + tableName + "`");
        this.writeLine("--");
    }

    private void writeLine(String line) throws IOException {
        this.bufferedWriter.write(line);
        this.bufferedWriter.newLine();
    }

    private void beforeRun() throws Exception {
        this.bufferedWriter = new BufferedWriter(new FileWriter(this.filename));
    }

    private void afterRun() {
        IOUtil.close(this.bufferedWriter);
    }
}

