/*
 * Decompiled with CFR 0.152.
 */
package worker.ddl;

import com.alibaba.druid.util.JdbcUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.FileUtil;
import util.IOUtil;
import worker.MyThreadPool;
import worker.ddl.DdlExportWorker;

public class DdlImporter {
    private static final Logger logger = LoggerFactory.getLogger(DdlExportWorker.class);
    private static final int DDL_RETRY_COUNT = 3;
    private static final int DDL_PARALLELISM = 10;
    private final List<String> filepaths = new ArrayList<String>();
    private final DataSource dataSource;
    private final ExecutorService ddlThreadPool = MyThreadPool.createFixedExecutor("DDL-importer", 10);
    private final AtomicInteger taskCount = new AtomicInteger(0);
    private volatile String useDbSql = null;

    public DdlImporter(String filename, DataSource dataSource) {
        this.dataSource = dataSource;
        File file = new File(filename);
        if (!file.exists() || !file.isFile()) {
            throw new IllegalStateException("File " + filename + " does not exist");
        }
        this.filepaths.add(file.getAbsolutePath());
    }

    public DdlImporter(List<String> tableNames, DataSource dataSource) {
        this.dataSource = dataSource;
        for (String name : tableNames) {
            String filename = name + ".ddl";
            String fileAbsPath = FileUtil.getFileAbsPath(filename);
            this.filepaths.add(fileAbsPath);
        }
    }

    public synchronized void doImportSync() {
        if (this.ddlThreadPool.isShutdown()) {
            throw new IllegalStateException("ddl thread pool has been shutdown");
        }
        BufferedReader reader = null;
        StringBuilder sqlStringBuilder = new StringBuilder(100);
        String line = null;
        boolean firstLine = true;
        try {
            for (String filepath : this.filepaths) {
                reader = new BufferedReader(new FileReader(filepath));
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("--") || line.isEmpty()) continue;
                    if (!line.endsWith(";")) {
                        sqlStringBuilder.append(line).append("\n");
                        continue;
                    }
                    sqlStringBuilder.append(line);
                    String sql = sqlStringBuilder.toString();
                    if (firstLine && (sql.contains("DATABASE") || sql.contains("database"))) {
                        this.importDDL(sql);
                    } else if (this.useDbSql == null && sql.startsWith("use")) {
                        this.useDbSql = sql;
                    } else {
                        this.submitDDL(sql);
                    }
                    firstLine = false;
                    sqlStringBuilder.setLength(0);
                }
            }
            sqlStringBuilder.setLength(0);
            IOUtil.close(reader);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            IOUtil.close(reader);
        }
        this.ddlThreadPool.shutdown();
        int waitCount = 0;
        while ((waitCount = this.taskCount.get()) != 0) {
            logger.info("\u7b49\u5f85DDL\u5bfc\u5165\u7ed3\u675f\uff0c\u5269\u4f59\u4efb\u52a1\u6570\uff1a{}", (Object)waitCount);
            int sleepTimeMillis = (waitCount / 50 + 1) * 3000;
            try {
                Thread.sleep(sleepTimeMillis);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        logger.info("DDL\u8bed\u53e5\u5bfc\u5165\u5b8c\u6bd5");
    }

    private void importDDL(String sql) {
        try (Connection conn = this.dataSource.getConnection();
             Statement stmt = conn.createStatement();){
            logger.info("\u6b63\u5728\u6267\u884c DDL \u8bed\u53e5: {}", (Object)sql);
            stmt.execute(sql);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private void submitDDL(String sql) {
        this.taskCount.incrementAndGet();
        this.ddlThreadPool.submit(() -> {
            Connection conn = null;
            Statement stmt = null;
            String ddlSample = null;
            try {
                ddlSample = sql.substring(0, Math.min(50, sql.length()));
                conn = this.dataSource.getConnection();
                stmt = conn.createStatement();
                logger.info("\u6b63\u5728\u6267\u884c DDL \u8bed\u53e5: {} ...", (Object)ddlSample);
                if (this.useDbSql != null) {
                    stmt.execute(this.useDbSql);
                }
                stmt.execute(sql);
                this.taskCount.decrementAndGet();
            }
            catch (SQLException e) {
                block9: {
                    try {
                        int retryCount;
                        if (!e.getMessage().contains("ERR_GMS_ACCESS_TO_SYSTEM_TABLE") || stmt == null) break block9;
                        for (retryCount = 0; retryCount < 3; ++retryCount) {
                            try {
                                logger.info("\u6b63\u5728\u91cd\u8bd5 DDL \u8bed\u53e5: {} ...", (Object)ddlSample);
                                stmt.execute(sql);
                                break;
                            }
                            catch (SQLException e2) {
                                e2.printStackTrace();
                                continue;
                            }
                        }
                        if (retryCount >= 3) break block9;
                        this.taskCount.decrementAndGet();
                    }
                    catch (Throwable throwable) {
                        this.taskCount.decrementAndGet();
                        JdbcUtils.close(conn);
                        JdbcUtils.close(stmt);
                        throw throwable;
                    }
                    JdbcUtils.close(conn);
                    JdbcUtils.close(stmt);
                    return;
                }
                logger.error("Failed to import DDL: [{}] due to [{}]", (Object)sql, (Object)e.getMessage());
                this.taskCount.decrementAndGet();
                JdbcUtils.close(conn);
                JdbcUtils.close(stmt);
            }
            JdbcUtils.close(conn);
            JdbcUtils.close(stmt);
        });
    }
}

