/*
 * Decompiled with CFR 0.152.
 */
package worker.delete;

import java.util.List;
import model.db.FieldMetaInfo;
import model.db.PrimaryKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import worker.common.BaseDefaultConsumer;
import worker.util.DeleteUtil;

public class DeleteInConsumer
extends BaseDefaultConsumer {
    private static final Logger logger = LoggerFactory.getLogger(DeleteInConsumer.class);
    private List<PrimaryKey> pkList;
    private String[] pkValues;
    private List<FieldMetaInfo> fieldMetaInfoList;

    @Override
    protected void initLocalVars() {
        this.pkList = this.consumerContext.getTablePkList(this.tableName);
        this.pkValues = new String[this.pkList.size()];
        this.fieldMetaInfoList = this.consumerContext.getTableFieldMetaInfo(this.tableName).getFieldMetaInfoList();
    }

    @Override
    protected void fillLocalBuffer(StringBuilder stringBuilder, List<String> values) {
        for (int i = 0; i < this.pkList.size(); ++i) {
            this.pkValues[i] = values.get(this.pkList.get(i).getOrdinalPosition() - 1);
        }
        stringBuilder.append("(");
        DeleteUtil.appendPkValuesByFieldMetaInfo(stringBuilder, this.fieldMetaInfoList, this.pkList, this.pkValues);
        stringBuilder.append("),");
    }

    @Override
    protected String getSql(StringBuilder data) {
        data.setLength(data.length() - 1);
        return DeleteUtil.getDeleteUsingIn(this.tableName, this.consumerContext.getTablePkName(this.tableName), data.toString());
    }
}

