/*
 * Decompiled with CFR 0.152.
 */
package worker.delete;

import java.util.List;
import model.db.FieldMetaInfo;
import model.db.PrimaryKey;
import model.db.TableTopology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import worker.common.BaseShardedConsumer;
import worker.util.DeleteUtil;

public class ShardedDeleteInConsumer
extends BaseShardedConsumer {
    private static final Logger logger = LoggerFactory.getLogger(ShardedDeleteInConsumer.class);
    private List<PrimaryKey> pkList;
    private String[] pkValues;

    @Override
    protected void initLocalVars() {
        this.pkList = this.consumerContext.getTablePkList(this.tableName);
        this.pkValues = new String[this.pkList.size()];
    }

    @Override
    protected void fillLocalBuffer(StringBuilder localBuffer, List<String> values, List<FieldMetaInfo> fieldMetaInfoList) throws Throwable {
        for (int i = 0; i < this.pkList.size(); ++i) {
            this.pkValues[i] = values.get(this.pkList.get(i).getOrdinalPosition() - 1);
        }
        localBuffer.append("(");
        DeleteUtil.appendPkValuesByFieldMetaInfo(localBuffer, fieldMetaInfoList, this.pkList, this.pkValues);
        localBuffer.append("),");
    }

    @Override
    protected String getSqlWithHint(TableTopology topology, StringBuilder data) {
        data.setLength(data.length() - 1);
        return DeleteUtil.getBatchDeleteSqlWithHint(topology.getGroupName(), topology.getTableName(), this.consumerContext.getTablePkList(this.tableName), data.toString(), this.consumerContext.getWhereCondition());
    }
}

