/*
 * Decompiled with CFR 0.152.
 */
package worker.export;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import model.config.CompressMode;
import model.config.FileFormat;
import model.config.QuoteEncloseMode;
import model.db.FieldMetaInfo;
import model.db.TableFieldMetaInfo;
import model.db.TableTopology;
import util.FileUtil;

public abstract class BaseExportWorker
implements Runnable {
    protected final DataSource druid;
    protected final TableTopology topology;
    protected final TableFieldMetaInfo tableFieldMetaInfo;
    protected final byte[] separator;
    protected final List<byte[]> specialCharList;
    protected final QuoteEncloseMode quoteEncloseMode;
    protected CompressMode compressMode;
    protected FileFormat fileFormat;
    protected final List<Boolean> isStringTypeList;

    protected BaseExportWorker(DataSource druid, TableTopology topology, TableFieldMetaInfo tableFieldMetaInfo, String separator, QuoteEncloseMode quoteEncloseMode) {
        this(druid, topology, tableFieldMetaInfo, separator, quoteEncloseMode, CompressMode.NONE, FileFormat.NONE);
    }

    protected BaseExportWorker(DataSource druid, TableTopology topology, TableFieldMetaInfo tableFieldMetaInfo, String separator, QuoteEncloseMode quoteEncloseMode, CompressMode compressMode, FileFormat fileFormat) {
        this.druid = druid;
        this.topology = topology;
        this.tableFieldMetaInfo = tableFieldMetaInfo;
        this.separator = separator.getBytes();
        this.specialCharList = new ArrayList<byte[]>();
        this.specialCharList.add(this.separator);
        this.specialCharList.add(FileUtil.CR_BYTE);
        this.specialCharList.add(FileUtil.LF_BYTE);
        this.specialCharList.add(FileUtil.DOUBLE_QUOTE_BYTE);
        this.quoteEncloseMode = quoteEncloseMode;
        this.isStringTypeList = tableFieldMetaInfo.getFieldMetaInfoList().stream().map(info -> info.getType() == FieldMetaInfo.Type.STRING).collect(Collectors.toList());
        switch (compressMode) {
            case NONE: 
            case GZIP: {
                this.compressMode = compressMode;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported compression mode: " + compressMode.name());
            }
        }
        this.fileFormat = fileFormat;
    }

    protected void writeFieldValue(ByteArrayOutputStream os, byte[] value, boolean isStringType) throws IOException {
        switch (this.quoteEncloseMode) {
            case NONE: {
                FileUtil.writeToByteArrayStream(os, value);
                break;
            }
            case FORCE: {
                FileUtil.writeToByteArrayStreamWithQuote(os, value);
                break;
            }
            case AUTO: {
                if (!isStringType) {
                    FileUtil.writeToByteArrayStream(os, value);
                    break;
                }
                boolean needQuote = FileUtil.containsSpecialBytes(value, this.specialCharList);
                if (needQuote) {
                    FileUtil.writeToByteArrayStreamWithQuote(os, value);
                    break;
                }
                FileUtil.writeToByteArrayStream(os, value);
            }
        }
    }

    public void setCompressMode(CompressMode compressMode) {
        this.compressMode = compressMode;
    }
}

