/*
 * Decompiled with CFR 0.152.
 */
package worker.export;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import model.CyclicAtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.IOUtil;
import worker.export.ExportEvent;

public class CollectFragmentWorker
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CollectFragmentWorker.class);
    private final Queue<ExportEvent> fragmentQueue;
    private final String[] filePaths;
    private final CyclicAtomicInteger cyclicCounter;
    private final CountDownLatch fragmentCountLatch;

    public CollectFragmentWorker(Queue<ExportEvent> fragmentQueue, String[] filePaths, CyclicAtomicInteger cyclicCounter, CountDownLatch fragmentCountLatch) {
        this.fragmentQueue = fragmentQueue;
        this.filePaths = filePaths;
        this.cyclicCounter = cyclicCounter;
        this.fragmentCountLatch = fragmentCountLatch;
    }

    @Override
    public void run() {
        while (!this.fragmentQueue.isEmpty()) {
            ExportEvent exportEvent = this.fragmentQueue.poll();
            byte[] data = exportEvent.getData();
            String filePath = this.filePaths[this.cyclicCounter.next()];
            try {
                FileChannel appendChannel = FileChannel.open(Paths.get(filePath, new String[0]), StandardOpenOption.APPEND);
                IOUtil.writeNio(appendChannel, data);
                logger.debug("\u5411\u6587\u4ef6 {} \u5199\u5165\u788e\u7247\u6570\u636e ", (Object)filePath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.fragmentCountLatch.countDown();
    }
}

