/*
 * Decompiled with CFR 0.152.
 */
package worker.export;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import javax.sql.DataSource;
import model.config.CompressMode;
import model.config.FileFormat;
import model.config.GlobalVar;
import model.config.QuoteEncloseMode;
import model.db.FieldMetaInfo;
import model.db.TableFieldMetaInfo;
import model.db.TableTopology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.DataSourceUtil;
import util.FileUtil;
import worker.common.writer.IFileWriter;
import worker.common.writer.NioFileWriter;
import worker.export.BaseExportWorker;
import worker.util.ExportUtil;

public class DirectExportWorker
extends BaseExportWorker {
    private static final Logger logger = LoggerFactory.getLogger(DirectExportWorker.class);
    private static final int NO_FILE_SEQ = -1;
    private final String filename;
    private final IFileWriter fileWriter;
    private final int maxLine;
    private int curLineNum = 0;
    private int curFileSeq;
    protected String whereCondition;
    private final boolean isWithHeader;
    private CountDownLatch countDownLatch;
    private Semaphore permitted;

    public DirectExportWorker(DataSource dataSource, TableTopology topology, TableFieldMetaInfo tableFieldMetaInfo, String filename, String separator, boolean isWithHeader, QuoteEncloseMode quoteEncloseMode, CompressMode compressMode, FileFormat fileFormat, Charset charset) {
        this(dataSource, topology, tableFieldMetaInfo, 0, filename, separator, isWithHeader, quoteEncloseMode, compressMode, fileFormat, charset);
    }

    public DirectExportWorker(DataSource dataSource, TableTopology topology, TableFieldMetaInfo tableFieldMetaInfo, int maxLine, String filename, String separator, boolean isWithHeader, QuoteEncloseMode quoteEncloseMode, CompressMode compressMode, FileFormat fileFormat, Charset charset) {
        super(dataSource, topology, tableFieldMetaInfo, separator, quoteEncloseMode, compressMode, fileFormat);
        this.maxLine = maxLine;
        this.filename = filename;
        this.isWithHeader = isWithHeader;
        this.initFileSeq();
        this.fileWriter = this.initFileWriter(charset);
        this.createNewFile();
    }

    private void initFileSeq() {
        if (this.isLimitLine()) {
            this.curFileSeq = 0;
            if (this.maxLine < GlobalVar.EMIT_BATCH_SIZE) {
                throw new IllegalArgumentException("Max line should be greater than batch size: " + GlobalVar.EMIT_BATCH_SIZE);
            }
        } else {
            this.curFileSeq = -1;
        }
    }

    private IFileWriter initFileWriter(Charset charset) {
        return new NioFileWriter(this.compressMode, charset);
    }

    private void createNewFile() {
        String tmpFileName = this.getTmpFilename();
        this.fileWriter.nextFile(tmpFileName);
        if (this.isWithHeader) {
            this.appendHeader();
        }
    }

    private String getTmpFilename() {
        if (this.curFileSeq == -1 && this.compressMode == CompressMode.NONE && this.fileFormat == FileFormat.NONE) {
            return this.filename;
        }
        StringBuilder filenameBuilder = new StringBuilder(this.filename.length() + 6);
        filenameBuilder.append(this.filename);
        if (this.curFileSeq != -1) {
            filenameBuilder.append('-').append(this.curFileSeq);
        }
        if (this.fileFormat != FileFormat.NONE) {
            filenameBuilder.append(this.fileFormat.getSuffix());
        }
        if (this.compressMode == CompressMode.GZIP) {
            filenameBuilder.append(".gz");
        }
        return filenameBuilder.toString();
    }

    private void appendHeader() {
        if (this.fileWriter.produceByBlock()) {
            byte[] header = FileUtil.getHeaderBytes(this.tableFieldMetaInfo.getFieldMetaInfoList(), this.separator);
            this.fileWriter.write(header);
        } else {
            String[] headerValues = (String[])this.tableFieldMetaInfo.getFieldMetaInfoList().stream().map(FieldMetaInfo::getName).toArray(String[]::new);
            this.fileWriter.writeLine(headerValues);
        }
    }

    @Override
    public void run() {
        this.beforeRun();
        try {
            if (this.fileWriter.produceByBlock()) {
                this.produceData();
            } else {
                this.produceDataByLine();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        finally {
            this.afterRun();
        }
    }

    private void beforeRun() {
        if (this.permitted != null) {
            this.permitted.acquireUninterruptibly();
        }
    }

    private void afterRun() {
        this.countDownLatch.countDown();
        if (this.permitted != null) {
            this.permitted.release();
        }
        this.fileWriter.close();
    }

    private void produceData() {
        String sql = this.getExportSql();
        try (Connection conn = this.druid.getConnection();
             Statement stmt = DataSourceUtil.createStreamingStatement(conn);
             ResultSet resultSet = stmt.executeQuery(sql);){
            logger.info("{} \u5f00\u59cb\u5bfc\u51fa", (Object)this.topology);
            int bufferedRowNum = 0;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            int colNum = resultSet.getMetaData().getColumnCount();
            while (resultSet.next()) {
                byte[] value;
                for (int i = 1; i < colNum; ++i) {
                    value = resultSet.getBytes(i);
                    this.writeFieldValue(os, value, (Boolean)this.isStringTypeList.get(i - 1));
                    os.write(this.separator);
                }
                value = resultSet.getBytes(colNum);
                this.writeFieldValue(os, value, (Boolean)this.isStringTypeList.get(colNum - 1));
                os.write(FileUtil.SYS_NEW_LINE_BYTE);
                if (++bufferedRowNum != GlobalVar.EMIT_BATCH_SIZE) continue;
                if (this.isLimitLine() && this.curLineNum + bufferedRowNum > this.maxLine) {
                    this.createNewPartFile();
                }
                this.writeToFile(os);
                this.curLineNum += bufferedRowNum;
                bufferedRowNum = 0;
            }
            if (bufferedRowNum != 0) {
                if (this.isLimitLine() && this.curLineNum + bufferedRowNum > this.maxLine) {
                    this.createNewPartFile();
                }
                this.writeToFile(os);
                bufferedRowNum = 0;
            }
            logger.info("{} \u5bfc\u51fa\u5b8c\u6210", (Object)this.topology);
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
        }
    }

    private void writeToFile(ByteArrayOutputStream os) {
        byte[] data = os.toByteArray();
        this.fileWriter.write(data);
        os.reset();
    }

    private void produceDataByLine() {
        String sql = this.getExportSql();
        try (Connection conn = this.druid.getConnection();
             Statement stmt = DataSourceUtil.createStreamingStatement(conn);
             ResultSet rs = stmt.executeQuery(sql);){
            int colNum = rs.getMetaData().getColumnCount();
            int line = 0;
            while (rs.next()) {
                ++line;
                String[] values = new String[colNum];
                for (int i = 1; i < colNum + 1; ++i) {
                    String value = rs.getString(i);
                    values[i - 1] = value != null ? value : "\\N";
                }
                this.fileWriter.writeLine(values);
                if (line % 1000 != 0) continue;
                logger.info("{} \u5f53\u524d\u5df2\u5199\u5165\u884c\u6570: {} ", (Object)this.filename, (Object)line);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected String getExportSql() {
        return ExportUtil.getDirectSql(this.topology, this.tableFieldMetaInfo.getFieldMetaInfoList(), this.whereCondition);
    }

    private boolean isLimitLine() {
        return this.maxLine != 0;
    }

    private void createNewPartFile() {
        ++this.curFileSeq;
        this.createNewFile();
        this.curLineNum = 0;
    }

    public String getWhereCondition() {
        return this.whereCondition;
    }

    public void setWhereCondition(String whereCondition) {
        this.whereCondition = whereCondition;
    }

    public CountDownLatch getCountDownLatch() {
        return this.countDownLatch;
    }

    public void setCountDownLatch(CountDownLatch countDownLatch) {
        this.countDownLatch = countDownLatch;
    }

    public void setPermitted(Semaphore permitted) {
        this.permitted = permitted;
    }
}

