/*
 * Decompiled with CFR 0.152.
 */
package worker.export;

import com.lmax.disruptor.WorkHandler;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;
import model.config.CompressMode;
import model.db.TableFieldMetaInfo;
import util.FileUtil;
import worker.common.writer.IFileWriter;
import worker.common.writer.NioFileWriter;
import worker.export.ExportEvent;

public class ExportConsumer
implements WorkHandler<ExportEvent> {
    private final byte[] separator;
    private final TableFieldMetaInfo tableFieldMetaInfo;
    private final IFileWriter fileWriter;
    private final AtomicInteger emittedDataCounter;

    public ExportConsumer(String filename, AtomicInteger emittedDataCounter, boolean isWithHeader, byte[] separator, TableFieldMetaInfo tableFieldMetaInfo, CompressMode compressMode, Charset charset) {
        this.emittedDataCounter = emittedDataCounter;
        this.separator = separator;
        this.tableFieldMetaInfo = tableFieldMetaInfo;
        filename = this.getFilename(filename, compressMode);
        this.fileWriter = new NioFileWriter(filename, compressMode, charset);
        if (isWithHeader) {
            this.appendHeader();
        }
    }

    private String getFilename(String filename, CompressMode compressMode) {
        if (compressMode == CompressMode.GZIP) {
            return filename + ".gz";
        }
        return filename;
    }

    private void appendHeader() {
        byte[] header = FileUtil.getHeaderBytes(this.tableFieldMetaInfo.getFieldMetaInfoList(), this.separator);
        this.fileWriter.write(header);
    }

    @Override
    public void onEvent(ExportEvent exportEvent) {
        this.writeEvent(exportEvent.getData());
    }

    public void writeEvent(byte[] data) {
        try {
            this.fileWriter.write(data);
        }
        finally {
            this.emittedDataCounter.getAndDecrement();
        }
    }

    public void close() {
        this.fileWriter.close();
    }
}

