/*
 * Decompiled with CFR 0.152.
 */
package worker.export;

import com.alibaba.druid.util.JdbcUtils;
import com.lmax.disruptor.RingBuffer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import model.config.GlobalVar;
import model.config.QuoteEncloseMode;
import model.db.FieldMetaInfo;
import model.db.TableFieldMetaInfo;
import model.db.TableTopology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.DataSourceUtil;
import util.FileUtil;
import worker.export.BaseExportWorker;
import worker.export.ExportEvent;
import worker.util.ExportUtil;

public class ExportProducer
extends BaseExportWorker {
    private static final Logger logger = LoggerFactory.getLogger(ExportProducer.class);
    private final RingBuffer<ExportEvent> ringBuffer;
    private final CountDownLatch countDownLatch;
    private final AtomicInteger emittedDataCounter;
    private final boolean collectFragmentEnabled;
    private Queue<ExportEvent> fragmentQueue;
    private String whereCondition;
    private Semaphore permitted;

    public ExportProducer(DataSource druid, TableTopology topology, TableFieldMetaInfo tableFieldMetaInfo, RingBuffer<ExportEvent> ringBuffer, String separator, CountDownLatch countDownLatch, AtomicInteger emittedDataCounter, boolean collectFragmentEnabled, QuoteEncloseMode quoteEncloseMode) {
        super(druid, topology, tableFieldMetaInfo, separator, quoteEncloseMode);
        this.ringBuffer = ringBuffer;
        this.countDownLatch = countDownLatch;
        this.emittedDataCounter = emittedDataCounter;
        this.collectFragmentEnabled = collectFragmentEnabled;
    }

    @Override
    public void run() {
        this.beforeRun();
        try {
            this.produceData();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        finally {
            this.afterRun();
        }
    }

    private void beforeRun() {
        if (this.permitted != null) {
            this.permitted.acquireUninterruptibly();
        }
    }

    private void afterRun() {
        if (this.permitted != null) {
            this.permitted.release();
        }
        this.countDownLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceData() {
        List<FieldMetaInfo> metaInfoList = this.tableFieldMetaInfo.getFieldMetaInfoList();
        String sql = ExportUtil.getDirectSql(this.topology, metaInfoList, this.whereCondition);
        int bufferedRowNum = 0;
        ByteArrayOutputStream os = new ByteArrayOutputStream(metaInfoList.size() * 8);
        Connection conn = null;
        Statement stmt = null;
        ResultSet resultSet = null;
        try {
            conn = this.druid.getConnection();
            stmt = DataSourceUtil.createStreamingStatement(conn);
            logger.info("{} \u5f00\u59cb\u6267\u884c\u5bfc\u51fa", (Object)this.topology);
            resultSet = stmt.executeQuery(sql);
            int colNum = resultSet.getMetaData().getColumnCount();
            while (resultSet.next()) {
                byte[] value;
                for (int i = 1; i < colNum; ++i) {
                    value = resultSet.getBytes(i);
                    this.writeFieldValue(os, value, (Boolean)this.isStringTypeList.get(i - 1));
                    os.write(this.separator);
                }
                value = resultSet.getBytes(colNum);
                this.writeFieldValue(os, value, (Boolean)this.isStringTypeList.get(colNum - 1));
                os.write(FileUtil.SYS_NEW_LINE_BYTE);
                if (++bufferedRowNum != GlobalVar.EMIT_BATCH_SIZE) continue;
                this.emitData(os.toByteArray());
                os.reset();
                bufferedRowNum = 0;
            }
            if (bufferedRowNum != 0) {
                if (this.collectFragmentEnabled) {
                    this.emitRemainData(os.toByteArray());
                } else {
                    this.emitData(os.toByteArray());
                }
            }
            logger.info("{} \u53d1\u9001\u5b8c\u6210", (Object)this.topology);
        }
        catch (IOException | SQLException e) {
            try {
                e.printStackTrace();
                logger.error(e.getMessage());
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                JdbcUtils.close(stmt);
                JdbcUtils.close(conn);
                throw throwable;
            }
            JdbcUtils.close(resultSet);
            JdbcUtils.close(stmt);
            JdbcUtils.close(conn);
        }
        JdbcUtils.close(resultSet);
        JdbcUtils.close(stmt);
        JdbcUtils.close(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitData(byte[] data) {
        long sequence = this.ringBuffer.next();
        try {
            ExportEvent event = this.ringBuffer.get(sequence);
            event.setData(data);
        }
        finally {
            this.emittedDataCounter.getAndIncrement();
            this.ringBuffer.publish(sequence);
        }
    }

    private void emitRemainData(byte[] data) {
        this.fragmentQueue.add(new ExportEvent(data));
    }

    public String getWhereCondition() {
        return this.whereCondition;
    }

    public void setWhereCondition(String whereCondition) {
        this.whereCondition = whereCondition;
    }

    public Queue<ExportEvent> getFragmentQueue() {
        return this.fragmentQueue;
    }

    public void setFragmentQueue(Queue<ExportEvent> fragmentQueue) {
        this.fragmentQueue = fragmentQueue;
    }

    public void setPermitted(Semaphore permitted) {
        this.permitted = permitted;
    }
}

