/*
 * Decompiled with CFR 0.152.
 */
package worker.export.order;

import java.nio.charset.Charset;
import java.util.List;
import javax.sql.DataSource;
import model.config.CompressMode;
import model.config.FileFormat;
import model.config.QuoteEncloseMode;
import model.db.TableFieldMetaInfo;
import model.db.TableTopology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import worker.export.DirectExportWorker;
import worker.util.ExportUtil;

public class DirectOrderExportWorker
extends DirectExportWorker {
    private static final Logger logger = LoggerFactory.getLogger(DirectOrderExportWorker.class);
    private final List<String> orderByColumnName;
    private final boolean isAscending;

    public DirectOrderExportWorker(DataSource dataSource, String filename, TableFieldMetaInfo tableFieldMetaInfo, String tableName, List<String> orderByColumnName, int maxLine, Charset charset, String separator, boolean isAscending, boolean isWithHeader, QuoteEncloseMode quoteEncloseMode, CompressMode compressMode, FileFormat fileFormat) {
        super(dataSource, new TableTopology(tableName), tableFieldMetaInfo, maxLine, filename, separator, isWithHeader, quoteEncloseMode, compressMode, fileFormat, charset);
        this.orderByColumnName = orderByColumnName;
        this.isAscending = isAscending;
    }

    public void exportSerially() {
        this.run();
    }

    @Override
    protected String getExportSql() {
        return ExportUtil.getDirectOrderBySql(this.topology.getTableName(), this.tableFieldMetaInfo.getFieldMetaInfoList(), this.orderByColumnName, this.whereCondition, this.isAscending);
    }
}

