/*
 * Decompiled with CFR 0.152.
 */
package worker.export.order;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.sql.DataSource;
import model.db.TableFieldMetaInfo;
import model.db.TableTopology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.DataSourceUtil;
import util.FileUtil;
import worker.export.order.ParallelOrderByExportEvent;
import worker.util.ExportUtil;

public class LocalOrderByExportProducer
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(LocalOrderByExportProducer.class);
    private String whereCondition;
    private final LinkedList<ParallelOrderByExportEvent> orderByExportEventList;
    private final DataSource druid;
    private final TableTopology topology;
    private final TableFieldMetaInfo tableFieldMetaInfo;
    private final List<String> orderByColumnName;
    private final CountDownLatch countDownLatch;
    private boolean isAscending = true;

    public LocalOrderByExportProducer(DataSource druid, TableTopology topology, TableFieldMetaInfo tableFieldMetaInfo, LinkedList<ParallelOrderByExportEvent> orderByExportEventList, List<String> orderByColumnName, CountDownLatch countDownLatch) {
        this.tableFieldMetaInfo = tableFieldMetaInfo;
        this.orderByExportEventList = orderByExportEventList;
        this.druid = druid;
        this.orderByColumnName = orderByColumnName;
        this.topology = topology;
        this.countDownLatch = countDownLatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceData() {
        String sql = ExportUtil.getOrderBySql(this.topology, this.tableFieldMetaInfo.getFieldMetaInfoList(), this.orderByColumnName, this.whereCondition, this.isAscending);
        long startTime = System.currentTimeMillis();
        try (Connection conn = this.druid.getConnection();
             Statement stmt = DataSourceUtil.createStreamingStatement(conn);
             ResultSet resultSet = stmt.executeQuery(sql);){
            logger.info("{} \u5f00\u59cb\u83b7\u53d6\u6570\u636e", (Object)this.topology);
            int colNum = resultSet.getMetaData().getColumnCount();
            while (resultSet.next()) {
                byte[][] data = LocalOrderByExportProducer.getRowBytes(resultSet, colNum);
                this.orderByExportEventList.add(new ParallelOrderByExportEvent(data));
            }
            long endTime = System.currentTimeMillis();
            logger.debug("{} \u53d1\u9001\u81f3\u7f13\u51b2\u533a\u5b8c\u6bd5\uff0c\u8017\u65f6 {} s", (Object)this.topology, (Object)Float.valueOf((float)(endTime - startTime) / 1000.0f));
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        finally {
            this.countDownLatch.countDown();
        }
    }

    static byte[][] getRowBytes(ResultSet resultSet, int colNum) throws SQLException {
        byte[][] data = new byte[colNum][];
        for (int i = 0; i < colNum; ++i) {
            byte[] fieldValue = resultSet.getBytes(i + 1);
            data[i] = fieldValue != null ? fieldValue : FileUtil.NULL_ESC_BYTE;
        }
        return data;
    }

    @Override
    public void run() {
        this.produceData();
    }

    public void setAscending(boolean ascending) {
        this.isAscending = ascending;
    }

    public void setWhereCondition(String whereCondition) {
        this.whereCondition = whereCondition;
    }
}

